/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Set;
import org.mindswap.exceptions.CastingException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOWLConverter<T extends OWLObject>
implements OWLObjectConverter<T> {
    private final OWLClass target;
    private final Set<T> individuals;
    private final Constructor<? extends T> constructor;

    public GenericOWLConverter(Class<? extends T> impl, OWLClass target) {
        this(impl, target, Collections.emptySet());
    }

    public GenericOWLConverter(Class<? extends T> impl, OWLClass target, Set<T> individuals) {
        this.target = target;
        this.individuals = individuals;
        try {
            this.constructor = impl.getConstructor(OWLIndividual.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canCast(OWLObject object, boolean strictConversion) {
        if (object instanceof OWLIndividual) {
            OWLIndividual ind = (OWLIndividual)object;
            if (!strictConversion || ind.isType(this.target) || this.individuals.contains(object)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final T cast(OWLObject object, boolean strictConversion) {
        if (this.canCast(object, strictConversion)) {
            try {
                return (T)((OWLObject)this.constructor.newInstance((OWLIndividual)object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw CastingException.create(object, this.target);
    }

    public String toString() {
        return "OWL individual -> " + this.target + " (implemented by " + this.constructor.getDeclaringClass() + ")";
    }

    protected final Constructor<? extends T> getConstructor() {
        return this.constructor;
    }

    protected final OWLClass getTarget() {
        return this.target;
    }
}

