/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import impl.util.InternalFactory;
import org.mindswap.exceptions.CastingException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.ListVocabulary;
import org.mindswap.owl.list.OWLList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListConverter<V extends OWLValue>
implements OWLObjectConverter<OWLList<V>> {
    private final ListVocabulary<V> vocabulary;

    public ListConverter(ListVocabulary<V> vocabulary) {
        this.vocabulary = vocabulary;
    }

    @Override
    public boolean canCast(OWLObject object, boolean strictConversion) {
        if (object instanceof OWLIndividual) {
            OWLIndividual ind = (OWLIndividual)object;
            return ind.equals(this.vocabulary.nil()) || ind.isType(this.vocabulary.list()) || null != this.isConvertibleList(ind) || ind.hasProperty(this.vocabulary.first()) && ind.hasProperty(this.vocabulary.rest());
        }
        return false;
    }

    @Override
    public OWLList<V> cast(OWLObject object, boolean strictConversion) {
        OWLList<?> list = this.isConvertibleList(object);
        if (list != null) {
            ListVocabulary<V> lv = new ListVocabulary<V>(list.getVocabulary().list(), list.getVocabulary().first(), list.getVocabulary().rest(), list.getVocabulary().nil(), this.vocabulary.itemAbstraction());
            return InternalFactory.wrapOWLList(list, lv);
        }
        if (this.canCast(object, strictConversion)) {
            OWLIndividual listInd = (OWLIndividual)object;
            return InternalFactory.wrapOWLList(listInd, this.vocabulary);
        }
        throw CastingException.create(object, this.vocabulary.list());
    }

    public String toString() {
        return "OWLIndividual -> OWLList (vocabulary " + this.vocabulary.list() + ", item abstraction " + this.vocabulary.itemAbstraction() + ")";
    }

    private final OWLList<?> isConvertibleList(OWLObject object) {
        if (object instanceof OWLList) {
            OWLList list = (OWLList)object;
            if (this.vocabulary.itemAbstraction().isAssignableFrom(list.getVocabulary().itemAbstraction())) {
                return list;
            }
        }
        return null;
    }
}

