/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIndividualListImpl<E extends OWLIndividual>
implements OWLIndividualList<E> {
    private final List<E> baseList;

    public OWLIndividualListImpl() {
        this.baseList = new ArrayList();
    }

    public OWLIndividualListImpl(List<E> l) {
        assert (l != null) : "Illegal: base list was null.";
        this.baseList = l;
    }

    public OWLIndividualListImpl(Collection<E> c) {
        assert (c != null) : "Illegal: base collection was null.";
        this.baseList = new ArrayList<E>(c);
    }

    public OWLIndividualListImpl(int initialCapacity) {
        this.baseList = new ArrayList(initialCapacity);
    }

    @Override
    public boolean addWithoutDuplicate(E individual) {
        if (this.contains(individual)) {
            return false;
        }
        return this.add(individual);
    }

    @Override
    public boolean addWithoutDuplicate(List<E> individuals) {
        boolean result = false;
        for (OWLIndividual individual : individuals) {
            result |= this.addWithoutDuplicate(individual);
        }
        return result;
    }

    @Override
    public E getIndividual(URI uri) {
        for (OWLIndividual element : this.baseList) {
            if (element.isAnon() || !element.getURI().equals(uri)) continue;
            return (E)element;
        }
        return null;
    }

    @Override
    public E getIndividual(String localName) {
        for (OWLIndividual element : this.baseList) {
            if (element.isAnon() || !element.getLocalName().equals(localName)) continue;
            return (E)element;
        }
        return null;
    }

    @Override
    public boolean add(E o) {
        return this.baseList.add(o);
    }

    @Override
    public void add(int index, E element) {
        this.baseList.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.baseList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.baseList.addAll(index, c);
    }

    @Override
    public void clear() {
        this.baseList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.baseList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.baseList.containsAll(c);
    }

    @Override
    public E get(int index) {
        return (E)((OWLIndividual)this.baseList.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.baseList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.baseList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.baseList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.baseList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.baseList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.baseList.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.baseList.remove(o);
    }

    @Override
    public E remove(int index) {
        return (E)((OWLIndividual)this.baseList.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.baseList.retainAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.baseList.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return (E)((OWLIndividual)this.baseList.set(index, element));
    }

    @Override
    public int size() {
        return this.baseList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.baseList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.baseList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.baseList.toArray(a);
    }

    public String toString() {
        return this.baseList.toString();
    }

    protected List<E> getBaseList() {
        return this.baseList;
    }
}

