/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import impl.owls.grounding.AtomicGroundingImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Future;
import org.mindswap.common.CompletedFuture;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.InvalidOWLSException;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.JavaGrounding;
import org.mindswap.owls.grounding.JavaParameter;
import org.mindswap.owls.grounding.JavaVariable;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.Parameter;
import org.mindswap.owls.vocabulary.MoreGroundings;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAtomicGroundingImpl
extends AtomicGroundingImpl<Object>
implements JavaAtomicGrounding {
    private static final String NO_MESSAGE_MAPS = "Java atomic process grounding does not use message maps.";
    private static final Logger logger = LoggerFactory.getLogger(JavaAtomicGroundingImpl.class);
    private Class<?> clazz;
    private Method method;
    private Class<?>[] methodParamsType;
    private OWLIndividualList<JavaParameter> inputParameters;
    private OWLIndividualList<Input> owlsInputs;
    private JavaVariable outputParameter;
    private Output owlsOutput;
    private OWLType owlsOutputType;

    public JavaAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public void setClazz(String claz) {
        this.clazz = null;
        this.setProperty(MoreGroundings.Java.javaClass, claz);
    }

    @Override
    public String getClazz() {
        return this.getPropertyAsString(MoreGroundings.Java.javaClass);
    }

    @Override
    public void setMethod(String method) {
        this.method = null;
        this.methodParamsType = null;
        this.setProperty(MoreGroundings.Java.javaMethod, method);
    }

    @Override
    public String getMethod() {
        return this.getPropertyAsString(MoreGroundings.Java.javaMethod);
    }

    @Override
    public URL getDescriptionURL() {
        throw new UnsupportedOperationException("This property does not exist for Java atomic process groundings.");
    }

    public JavaGrounding getGrounding() {
        return this.getGrounding(JavaGrounding.class);
    }

    @Override
    public void addInputMap(MessageMap<Object> map) {
        throw new UnsupportedOperationException(NO_MESSAGE_MAPS);
    }

    @Override
    public void addOutputMap(MessageMap<Object> map) {
        throw new UnsupportedOperationException(NO_MESSAGE_MAPS);
    }

    @Override
    public void addMessageMap(Parameter owlsParameter, String groundingParameter, Object transformation) {
        throw new UnsupportedOperationException(NO_MESSAGE_MAPS);
    }

    @Override
    public OWLIndividualList<MessageMap<Object>> getInputMappings() {
        throw new UnsupportedOperationException(NO_MESSAGE_MAPS);
    }

    @Override
    public OWLIndividualList<MessageMap<Object>> getOutputMappings() {
        throw new UnsupportedOperationException(NO_MESSAGE_MAPS);
    }

    @Override
    public Future<ValueMap<Output, OWLValue>> invoke(ValueMap<Input, OWLValue> values) {
        return this.invoke(values, OWLFactory.createKB());
    }

    @Override
    public Future<ValueMap<Output, OWLValue>> invoke(ValueMap<Input, OWLValue> inputs, OWLKnowledgeBase kb) {
        try {
            this.initClazz();
            this.initMethod();
            this.initInputs();
            Object[] methodParams = new Object[this.owlsInputs.size()];
            int i = 0;
            for (Input input : this.owlsInputs) {
                OWLValue inputValue = this.getParameterValue(input, inputs);
                methodParams[i] = this.getParameterValue((JavaParameter)this.inputParameters.get(i), this.methodParamsType[i], inputValue);
                ++i;
            }
            Object instance = Modifier.isStatic(this.method.getModifiers()) ? null : this.clazz.newInstance();
            Object result = this.method.invoke(instance, methodParams);
            ValueMap<Output, OWLValue> results = new ValueMap<Output, OWLValue>();
            if (result != null) {
                JavaVariable outputVariable = this.getOutput();
                if (outputVariable == null) {
                    logger.debug("Return value of {} ignored because JavaAtomicGrounding does not specify javaOutput property.", (Object)this.toString());
                } else {
                    this.initOutput();
                    if (this.owlsOutputType.isDataType()) {
                        results.setValue(this.owlsOutput, this.getOntology().createDataValue(result));
                    } else {
                        results.setValue(this.owlsOutput, outputVariable.getTransformator(false).toOWL(result, this.getKB()));
                    }
                }
            }
            return CompletedFuture.createSuccessCompletionFuture(results);
        }
        catch (Exception e) {
            return CompletedFuture.createExceptionCompletionFuture(e);
        }
    }

    private Object getParameterValue(JavaParameter param, Class<?> paramType, OWLValue sourceValue) throws ExecutionException {
        if (paramType.isInstance(sourceValue)) {
            return sourceValue;
        }
        if (sourceValue.isDataValue()) {
            return ((OWLDataValue)sourceValue).getValue();
        }
        return param.getTransformator(true).fromOWL(sourceValue, this.getKB());
    }

    @Override
    public void setOutput(URI uri, String type, Output owlsParameter) {
        this.outputParameter = null;
        this.owlsOutput = null;
        this.owlsOutputType = null;
        OWLIndividual ind = this.getOntology().createInstance(MoreGroundings.Java.JavaVariable, uri);
        ind.setProperty(MoreGroundings.Java.javaType, type);
        ind.setProperty(MoreGroundings.Java.owlsParameter, owlsParameter);
        this.setProperty(MoreGroundings.Java.javaOutput, ind);
    }

    @Override
    public void addInputParameter(URI uri, String type, int index, Input owlsParameter) {
        this.inputParameters = null;
        this.owlsInputs = null;
        OWLIndividual ind = this.getOntology().createInstance(MoreGroundings.Java.JavaParameter, uri);
        ind.setProperty(MoreGroundings.Java.javaType, type);
        ind.setProperty(MoreGroundings.Java.owlsParameter, owlsParameter);
        ind.setProperty(MoreGroundings.Java.paramIndex, index);
        this.addProperty(MoreGroundings.Java.hasJavaParameter, ind);
    }

    @Override
    public String getGroundingType() {
        return "Java";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Java grounding method ");
        sb.append(this.getClazz()).append(".").append(this.getMethod()).append("(");
        for (JavaParameter param : this.getInputParameters()) {
            sb.append(param.getJavaType());
            if (param.getParameterIndex() <= 0) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private void removeAll() {
        this.removeProperty(MoreGroundings.Java.javaClass, null);
        this.removeProperty(MoreGroundings.Java.javaMethod, null);
        if (this.hasProperty(MoreGroundings.Java.hasJavaParameter)) {
            OWLIndividualList<?> indList = this.getProperties(MoreGroundings.Java.hasJavaParameter);
            for (OWLIndividual ind : indList) {
                ind.removeProperty(MoreGroundings.Java.javaType, null);
                ind.removeProperty(MoreGroundings.Java.owlsParameter, null);
                ind.removeProperty(MoreGroundings.Java.paramIndex, null);
                this.removeProperty(MoreGroundings.Java.hasJavaParameter, ind);
                ind.delete();
            }
        }
        if (this.hasProperty(MoreGroundings.Java.javaOutput)) {
            OWLIndividual ind = this.getProperty(MoreGroundings.Java.javaOutput);
            ind.removeProperty(MoreGroundings.Java.javaType, null);
            ind.removeProperty(MoreGroundings.Java.owlsParameter, null);
            this.removeProperty(MoreGroundings.Java.javaOutput, null);
            ind.delete();
        }
        this.removeProperty(OWLS_1_2.Grounding.owlsProcess, null);
    }

    @Override
    public void delete() {
        this.removeAll();
        super.delete();
    }

    @Override
    public JavaParameter getInputParamter(Input input) {
        for (JavaParameter param : this.getInputParameters()) {
            Parameter owlsParam = param.getOWLSParameter();
            if (!owlsParam.equals(input)) continue;
            return param;
        }
        return null;
    }

    @Override
    public JavaVariable getOutput() {
        if (this.outputParameter == null) {
            this.outputParameter = this.getPropertyAs(MoreGroundings.Java.javaOutput, JavaVariable.class);
        }
        return this.outputParameter;
    }

    @Override
    public OWLIndividualList<JavaParameter> getInputParameters() {
        if (this.inputParameters == null) {
            this.inputParameters = this.getPropertiesAs(MoreGroundings.Java.hasJavaParameter, JavaParameter.class);
            Collections.sort(this.inputParameters, new Comparator<JavaParameter>(){

                @Override
                public int compare(JavaParameter p1, JavaParameter p2) {
                    Integer i1 = p1.getParameterIndex();
                    Integer i2 = p2.getParameterIndex();
                    return i1.compareTo(i2);
                }
            });
        }
        return this.inputParameters;
    }

    private void initClazz() throws ClassNotFoundException {
        if (this.clazz == null) {
            String clazzName = this.getClazz();
            if (clazzName == null || clazzName.trim().length() == 0) {
                throw new InvalidOWLSException("Java class name not specified in JavaAtomicGrounding!");
            }
            this.clazz = Class.forName(clazzName);
        }
    }

    private void initMethod() throws SecurityException, NoSuchMethodException {
        if (this.method == null) {
            String methodName = this.getMethod();
            if (methodName == null || methodName.trim().length() == 0) {
                throw new InvalidOWLSException("Java method name not specified in JavaAtomicGrounding!");
            }
            OWLIndividualList<JavaParameter> params = this.getInputParameters();
            this.methodParamsType = new Class[params.size()];
            int i = 0;
            for (JavaParameter param : params) {
                String paramClassName = param.getJavaType();
                this.methodParamsType[i] = ReflectionUtils.getClassFromString(paramClassName);
                ++i;
            }
            this.method = this.clazz.getMethod(methodName, this.methodParamsType);
        }
    }

    private void initInputs() {
        if (this.owlsInputs == null) {
            this.owlsInputs = OWLFactory.createIndividualList(this.getInputParameters().size());
            for (JavaParameter inputParam : this.inputParameters) {
                Input input = inputParam.getOWLSParameter().castTo(Input.class);
                this.owlsInputs.add(input);
            }
        }
    }

    private void initOutput() {
        JavaVariable outputVariable;
        Parameter ind;
        if (this.owlsOutput == null && (ind = (outputVariable = this.getOutput()).getOWLSParameter()) != null) {
            this.owlsOutput = ind.castTo(Output.class);
            this.owlsOutputType = this.owlsOutput.getParamType();
        }
    }
}

