/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import impl.owls.grounding.AtomicGroundingImpl;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.Parameter;
import org.mindswap.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageMapAtomicGroundingImpl<T>
extends AtomicGroundingImpl<T> {
    private OWLIndividualList<? extends MessageMap<T>> inputMessageMappings;
    private OWLIndividualList<? extends MessageMap<T>> outputMessageMappings;

    public MessageMapAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public void addInputMap(MessageMap<T> map) {
        this.inputMessageMappings = null;
        this.addProperty(this.inputMessageMapProperty(), map);
    }

    @Override
    public void addMessageMap(Parameter owlsParameter, String groundingParameter, T transformation) {
        MessageMap<T> map = null;
        if (owlsParameter instanceof Input) {
            map = this.createInputMessageMap();
            this.addInputMap(map);
        } else if (owlsParameter instanceof Output) {
            map = this.createOutputMessageMap();
            this.addOutputMap(map);
        } else {
            throw new IllegalArgumentException("OWL-S parameter is neither an Input nor Output!");
        }
        map.setOWLSParameter(owlsParameter);
        map.setGroundingParameter(groundingParameter);
        if (transformation != null) {
            map.setTransformation(transformation);
        }
    }

    @Override
    public void addOutputMap(MessageMap<T> map) {
        this.outputMessageMappings = null;
        this.addProperty(this.outputMessageMapProperty(), map);
    }

    @Override
    public OWLIndividualList<? extends MessageMap<T>> getInputMappings() {
        if (this.inputMessageMappings == null) {
            this.inputMessageMappings = this.getPropertiesAs(this.inputMessageMapProperty(), this.messageMapType());
        }
        return this.inputMessageMappings;
    }

    @Override
    public OWLIndividualList<? extends MessageMap<T>> getOutputMappings() {
        if (this.outputMessageMappings == null) {
            this.outputMessageMappings = this.getPropertiesAs(this.outputMessageMapProperty(), this.messageMapType());
        }
        return this.outputMessageMappings;
    }

    protected final MessageMap<T> getMessageMap(Parameter p) {
        for (MessageMap messageMap : p instanceof Input ? this.getInputMappings() : this.getOutputMappings()) {
            if (!messageMap.getOWLSParameter().equals(p)) continue;
            return messageMap;
        }
        return null;
    }

    protected final MessageMap<T> getMessageMap(boolean inputs, String uri) {
        String name = URIUtils.getLocalName(uri);
        for (MessageMap messageMap : inputs ? this.getInputMappings() : this.getOutputMappings()) {
            String u = messageMap.getGroundingParameter();
            String n = URIUtils.getLocalName(u);
            if (!uri.equals(u) && (name == null || !name.equals(n))) continue;
            return messageMap;
        }
        return null;
    }

    protected void removeMessageMaps(boolean inputs) {
        OWLObjectProperty prop;
        OWLObjectProperty oWLObjectProperty = prop = inputs ? this.inputMessageMapProperty() : this.outputMessageMapProperty();
        if (this.hasProperty(prop)) {
            for (OWLIndividual ind : this.getProperties(prop)) {
                this.removeProperty(prop, ind);
                ind.delete();
            }
        }
    }

    protected abstract MessageMap<T> createInputMessageMap();

    protected abstract MessageMap<T> createOutputMessageMap();

    protected abstract OWLObjectProperty inputMessageMapProperty();

    protected abstract OWLObjectProperty outputMessageMapProperty();

    protected abstract Class<? extends MessageMap<T>> messageMapType();
}

