/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.Device;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.UPnPStatus;
import impl.owls.grounding.MessageMapAtomicGroundingImpl;
import java.net.URL;
import java.util.concurrent.Future;
import org.mindswap.common.CompletedFuture;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.UPnPGrounding;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.Utils;
import org.mindswap.utils.XSLTEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPnPAtomicGroundingImpl
extends MessageMapAtomicGroundingImpl<String>
implements UPnPAtomicGrounding {
    private static final Logger logger = LoggerFactory.getLogger(UPnPAtomicGroundingImpl.class);

    public UPnPAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    public UPnPGrounding getGrounding() {
        return this.getGrounding(UPnPGrounding.class);
    }

    @Override
    public void setUPnPService(String service) {
        this.setProperty(FLAServiceOnt.upnpServiceID, service);
    }

    @Override
    public String getUPnPService() {
        return this.getPropertyAsString(FLAServiceOnt.upnpServiceID);
    }

    @Override
    public void setUPnPAction(String action) {
        this.setProperty(FLAServiceOnt.upnpCommand, action);
    }

    @Override
    public String getUPnPAction() {
        return this.getPropertyAsString(FLAServiceOnt.upnpCommand);
    }

    @Override
    public URL getDescriptionURL() {
        try {
            ControlPoint cp = new ControlPoint();
            Device device = cp.getProxyDevice(this.getUPnPDescription());
            String url = device.getPresentationURL();
            cp.stop();
            return new URL(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setUPnPDescription(String description) {
        this.setProperty(FLAServiceOnt.upnpDeviceURL, description);
    }

    @Override
    public String getUPnPDescription() {
        return this.getPropertyAsString(FLAServiceOnt.upnpDeviceURL);
    }

    @Override
    public Future<ValueMap<Output, OWLValue>> invoke(ValueMap<Input, OWLValue> values) {
        return this.invoke(values, OWLFactory.createKB());
    }

    @Override
    public Future<ValueMap<Output, OWLValue>> invoke(ValueMap<Input, OWLValue> inputs, OWLKnowledgeBase env) {
        ControlPoint cp = new ControlPoint();
        Device device = cp.getProxyDevice(this.getUPnPDescription());
        Service service = device.getService(this.getUPnPService());
        Action action = service.getAction(this.getUPnPAction());
        ArgumentList inArguments = action.getInputArgumentList();
        try {
            for (int i = 0; i < inArguments.size(); ++i) {
                Object value;
                Argument in = inArguments.getArgument(i);
                MessageMap mp = this.getMessageMap(true, in.getName());
                Input input = mp.getOWLSParameter().castTo(Input.class);
                Object inputValue = value = this.getParameterValue(input, inputs);
                if (mp.getTransformation() != null) {
                    value = XSLTEngine.transform(value.toString(), (String)mp.getTransformation());
                    Node node = Utils.getAsNode(value.toString());
                    inputValue = node.getFirstChild().getNodeValue();
                }
                logger.debug("Parameter {}, value = {}", (Object)input, value);
                action.setArgumentValue(mp.getGroundingParameter(), inputValue.toString());
            }
            boolean ctrlRes = action.postControlAction();
            if (!ctrlRes) {
                UPnPStatus err = action.getControlStatus();
                throw new ExecutionException(err.getDescription() + " (" + Integer.toString(err.getCode()) + ")");
            }
            ArgumentList outArguments = action.getOutputArgumentList();
            ValueMap<Output, OWLValue> results = new ValueMap<Output, OWLValue>();
            for (int i = 0; i < outArguments.size(); ++i) {
                Argument out = outArguments.getArgument(i);
                MessageMap mp = this.getMessageMap(false, out.getName());
                if (mp == null) continue;
                Output param = mp.getOWLSParameter().castTo(Output.class);
                String outputValue = null;
                outputValue = mp.getTransformation() == null ? out.getValue() : XSLTEngine.transform(out.getValue(), (String)mp.getTransformation());
                if (param.getParamType().isDataType()) {
                    results.setValue(param, env.createDataValue((Object)outputValue));
                    continue;
                }
                results.setValue(param, env.parseLiteral(outputValue.toString()));
            }
            return CompletedFuture.createSuccessCompletionFuture(results);
        }
        catch (Exception e) {
            return CompletedFuture.createExceptionCompletionFuture(e);
        }
    }

    @Override
    public String getGroundingType() {
        return "UPNP";
    }

    @Override
    protected MessageMap<String> createInputMessageMap() {
        return this.getOntology().createUPnPMessageMap(null);
    }

    @Override
    protected MessageMap<String> createOutputMessageMap() {
        return this.getOntology().createUPnPMessageMap(null);
    }

    @Override
    protected OWLObjectProperty inputMessageMapProperty() {
        return FLAServiceOnt.upnpInputMapping;
    }

    @Override
    protected Class<? extends MessageMap<String>> messageMapType() {
        return MessageMap.StringMessageMap.class;
    }

    @Override
    protected OWLObjectProperty outputMessageMapProperty() {
        return FLAServiceOnt.upnpOutputMapping;
    }
}

