/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import impl.owls.grounding.MessageMapAtomicGroundingImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.Future;
import javax.xml.soap.SOAPElement;
import org.mindswap.common.CompletedFuture;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.ServiceNotAvailableException;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLGrounding;
import org.mindswap.owls.grounding.WSDLOperationRef;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.Parameter;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.URIUtils;
import org.mindswap.utils.Utils;
import org.mindswap.utils.XSLTEngine;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLAtomicGroundingImpl
extends MessageMapAtomicGroundingImpl<String>
implements WSDLAtomicGrounding {
    private static final Logger logger = LoggerFactory.getLogger(WSDLAtomicGroundingImpl.class);
    private WSDLOperation wsdlOperation;

    public WSDLAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    public WSDLGrounding getGrounding() {
        return this.getGrounding(WSDLGrounding.class);
    }

    @Override
    public void setWSDL(URI wsdlLoc) {
        this.wsdlOperation = null;
        this.setProperty(OWLS_1_2.Grounding.wsdlDocument, wsdlLoc);
    }

    @Override
    public URI getWSDL() {
        return this.getPropertyAsURI(OWLS_1_2.Grounding.wsdlDocument);
    }

    @Override
    public void setOperation(URI operation) {
        this.wsdlOperation = null;
        WSDLOperationRef opRef = this.getOperationRef();
        if (opRef == null) {
            opRef = this.getOntology().createWSDLOperationRef(null);
            this.setOperationRef(opRef);
        }
        opRef.setOperation(operation);
    }

    @Override
    public URI getOperation() {
        return this.getOperationRef().getOperation();
    }

    @Override
    public void setPortType(URI port) {
        WSDLOperationRef opRef = this.getOperationRef();
        if (opRef == null) {
            opRef = this.getOntology().createWSDLOperationRef(null);
            this.setOperationRef(opRef);
        }
        opRef.setPortType(port);
    }

    @Override
    public URI getPortType() {
        return this.getOperationRef().getPortType();
    }

    @Override
    public Future<ValueMap<Output, OWLValue>> invoke(ValueMap<Input, OWLValue> values) {
        return this.invoke(values, OWLFactory.createKB());
    }

    @Override
    public Future<ValueMap<Output, OWLValue>> invoke(ValueMap<Input, OWLValue> inputs, OWLKnowledgeBase env) {
        try {
            this.initWSDLOperation();
            for (WSDLParameter in : this.wsdlOperation.getInputs()) {
                Object inputValueObj;
                MessageMap mp = this.getMessageMap(true, in.getName());
                if (mp == null) continue;
                Input input = mp.getOWLSParameter().castTo(Input.class);
                OWLValue inputValue = this.getParameterValue(input, inputs);
                String xslt = (String)mp.getTransformation();
                if (inputValue.isIndividual()) {
                    String rdfXML = ((OWLIndividual)inputValue).toRDF(true, true);
                    if (xslt != null) {
                        String xsltResult = XSLTEngine.transform(rdfXML, xslt, inputs);
                        inputValueObj = Utils.getAsNode(xsltResult);
                        if (inputValueObj == null) {
                            inputValueObj = xsltResult.trim();
                        }
                    } else {
                        logger.debug("No XSLT transformation for input parameter " + input + " specified." + " OWLIndividual bound to this parameter should be transformed rather than using" + " its RDF/XML serialization.");
                        inputValueObj = rdfXML;
                    }
                } else {
                    if (xslt != null) {
                        throw new ExecutionException("XSLT transformation for input parameter " + input + " cannot be applied to OWL data value (only to OWL individual).");
                    }
                    inputValueObj = ((OWLDataValue)inputValue).getValue();
                }
                in.setValue(inputValueObj);
            }
            this.wsdlOperation.invoke();
            ValueMap<Output, OWLValue> results = new ValueMap<Output, OWLValue>();
            for (Output outputParam : this.getProcess().getOutputs()) {
                Object outputValue;
                MessageMap mp = this.getMessageMap(outputParam);
                String wsdlMessagePart = mp.getGroundingParameter();
                String xslt = (String)mp.getTransformation();
                if (wsdlMessagePart != null && xslt == null) {
                    WSDLParameter out = this.wsdlOperation.getOutput(wsdlMessagePart);
                    if (out == null) {
                        throw new ExecutionException("WSDL message part " + wsdlMessagePart + " is not found in the response of the WSDL operation " + this.wsdlOperation);
                    }
                    outputValue = out.getValue();
                    if (outputValue == null) {
                        throw new ExecutionException("Value of output parameter " + out + " is not set in the response of the WSDL operation " + this.wsdlOperation);
                    }
                } else if (wsdlMessagePart == null && xslt != null) {
                    SOAPElement response = this.wsdlOperation.getResponse();
                    outputValue = XSLTEngine.transform((Node)response, xslt);
                    if (outputValue == null) {
                        throw new ExecutionException("Null value returned when applying XSLT transformtion for output parameter " + outputParam);
                    }
                } else {
                    throw new ExecutionException("WSDLOutputMessageMap for Output " + outputParam + " is neither a DirectOutputMessageMap nor XSLTOutputMessageMap.");
                }
                if (outputParam.getParamType().isDataType()) {
                    results.setValue(outputParam, env.createDataValue(outputValue));
                    continue;
                }
                results.setValue(outputParam, env.parseLiteral(outputValue.toString()));
            }
            return CompletedFuture.createSuccessCompletionFuture(results);
        }
        catch (Exception e) {
            return CompletedFuture.createExceptionCompletionFuture(e);
        }
    }

    @Override
    public URL getDescriptionURL() {
        try {
            return this.getWSDL().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URI getInputMessage() {
        return this.getPropertyAsURI(OWLS_1_2.Grounding.wsdlInputMessage);
    }

    @Override
    public void setInputMessage(URI inputMessage) {
        this.setProperty(OWLS_1_2.Grounding.wsdlInputMessage, inputMessage);
    }

    @Override
    public URI getOutputMessage() {
        return this.getPropertyAsURI(OWLS_1_2.Grounding.wsdlOutputMessage);
    }

    @Override
    public void setOutputMessage(URI outputMessage) {
        this.setProperty(OWLS_1_2.Grounding.wsdlOutputMessage, outputMessage);
    }

    @Override
    public WSDLOperationRef getOperationRef() {
        return this.getPropertyAs(OWLS_1_2.Grounding.wsdlOperation, WSDLOperationRef.class);
    }

    @Override
    public void setOperationRef(WSDLOperationRef operationRef) {
        this.setProperty(OWLS_1_2.Grounding.wsdlOperation, operationRef);
    }

    @Override
    public String getGroundingType() {
        return "WSDL";
    }

    public void removeOperationRef() {
        if (this.hasProperty(OWLS_1_2.Grounding.wsdlOperation)) {
            WSDLOperationRef opRef = this.getOperationRef();
            opRef.removeOperation();
            opRef.removePortType();
            this.removeProperty(OWLS_1_2.Grounding.wsdlOperation, null);
            opRef.delete();
        }
    }

    private void removeAll() {
        this.removeProperty(OWLS_1_2.Grounding.wsdlDocument, null);
        this.removeOperationRef();
        this.removeProperty(OWLS_1_2.Grounding.wsdlInputMessage, null);
        this.removeProperty(OWLS_1_2.Grounding.wsdlOutputMessage, null);
        this.removeMessageMaps(true);
        this.removeMessageMaps(false);
    }

    @Override
    public void delete() {
        this.removeAll();
        super.delete();
    }

    @Override
    public URI getWSDLParameter(Parameter parameter) {
        URI uri = this.getWSDLParameter(parameter, this.getInputMappings());
        if (uri == null) {
            uri = this.getWSDLParameter(parameter, this.getOutputMappings());
        }
        return uri;
    }

    @Override
    protected MessageMap<String> createInputMessageMap() {
        return this.getOntology().createWSDLInputMessageMap(null);
    }

    @Override
    protected MessageMap<String> createOutputMessageMap() {
        return this.getOntology().createWSDLOutputMessageMap(null);
    }

    @Override
    protected OWLObjectProperty inputMessageMapProperty() {
        return OWLS_1_2.Grounding.wsdlInput;
    }

    @Override
    protected OWLObjectProperty outputMessageMapProperty() {
        return OWLS_1_2.Grounding.wsdlOutput;
    }

    @Override
    protected Class<? extends MessageMap<String>> messageMapType() {
        return MessageMap.StringMessageMap.class;
    }

    private URI getWSDLParameter(Parameter parameter, OWLIndividualList<? extends MessageMap<String>> list) {
        for (MessageMap messageMap : list) {
            if (!messageMap.getOWLSParameter().equals(parameter)) continue;
            return messageMap.getGroundingParameterAsURI();
        }
        return null;
    }

    private void initWSDLOperation() throws ExecutionException {
        if (this.wsdlOperation == null) {
            WSDLService s;
            String operation = this.getOperation().toString();
            try {
                s = WSDLService.createService(this.getWSDL());
            }
            catch (Exception e) {
                throw new ServiceNotAvailableException(this.getProcess(), e);
            }
            this.wsdlOperation = s.getOperation(operation);
            if (this.wsdlOperation == null) {
                this.wsdlOperation = s.getOperation(URIUtils.getLocalName(operation));
            }
            if (this.wsdlOperation == null) {
                throw new ExecutionException("Operation " + operation + " not found in the WSDL description");
            }
        }
    }
}

