/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process;

import impl.owls.process.ProcessImpl;
import java.net.URI;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.vocabulary.OWL;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.execution.ExecutionContext;
import org.mindswap.owls.process.execution.ExecutionSupport;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.Link;
import org.mindswap.owls.process.variable.Loc;
import org.mindswap.owls.process.variable.Local;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.owls.process.variable.ValueOf;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.owls.vocabulary.OWLS_Extensions;
import org.mindswap.utils.ProcessDataFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeProcessImpl
extends ProcessImpl<CompositeProcessImpl>
implements CompositeProcess {
    private static final Logger logger = LoggerFactory.getLogger(CompositeProcessImpl.class);

    public CompositeProcessImpl(OWLIndividual ind) {
        super(ind);
        this.process = this;
    }

    @Override
    public void addLocal(Local local) {
        this.addProperty(OWLS_1_2.Process.hasLocal, local);
    }

    @Override
    public void addLocals(OWLIndividualList<? extends Local> locals) {
        for (Local local : locals) {
            this.addLocal(local);
        }
    }

    @Override
    public Loc createLoc(URI uri, OWLType varType) {
        Loc local = this.getOntology().createLoc(uri);
        if (varType != null) {
            local.setParamType(varType);
        }
        this.addLocal(local);
        return local;
    }

    @Override
    public Link createLink(URI uri, OWLType varType) {
        Link link = this.getOntology().createLink(uri);
        if (varType != null) {
            link.setParamType(varType);
        }
        this.addLocal(link);
        return link;
    }

    @Override
    public Local getLocal() {
        return this.getPropertyAs(OWLS_1_2.Process.hasLocal, Local.class);
    }

    @Override
    public Local getLocal(String localName) {
        OWLIndividualList<Local> locals = this.getLocals();
        return locals.getIndividual(localName);
    }

    @Override
    public OWLIndividualList<Local> getLocals() {
        return this.getPropertiesAs(OWLS_1_2.Process.hasLocal, Local.class);
    }

    @Override
    public void removeLocal(Local local) {
        this.removeProperty(OWLS_1_2.Process.hasLocal, local);
    }

    @Override
    public ControlConstruct getComposedOf() {
        return this.getPropertyAs(OWLS_1_2.Process.composedOf, ControlConstruct.class);
    }

    @Override
    public void setComposedOf(ControlConstruct construct) {
        this.setProperty(OWLS_1_2.Process.composedOf, construct);
    }

    @Override
    public OWLIndividualList<Binding<?>> getAllBindings() {
        OWLIndividualList<Binding<?>> bindings = OWLFactory.createIndividualList();
        ControlConstruct cc = this.getComposedOf();
        bindings.addAll(cc.getAllBindings());
        for (Result result : this.getResults()) {
            bindings.addAll(result.getBindings());
        }
        return bindings;
    }

    @Override
    public void removeComposedOf() {
        this.removeProperty(OWLS_1_2.Process.composedOf, null);
    }

    @Override
    public <C extends ExecutionContext> void execute(C context, ExecutionSupport<C> target) throws ExecutionException {
        target.executeCompositeProcess((CompositeProcess)((Object)this.process), context);
    }

    @Override
    public Expression<?> getComputedEffect() {
        return this.getPropertyAs(OWLS_1_2.Process.computedEffect, Expression.class);
    }

    @Override
    public Expression<?> getComputedInput() {
        return this.getPropertyAs(OWLS_1_2.Process.computedInput, Expression.class);
    }

    @Override
    public Expression<?> getComputedOutput() {
        return this.getPropertyAs(OWLS_1_2.Process.computedOutput, Expression.class);
    }

    @Override
    public Expression<?> getComputedPrecondition() {
        return this.getPropertyAs(OWLS_1_2.Process.computedPrecondition, Expression.class);
    }

    @Override
    public ProcessDataFlow getDataFlow(OWLOntology dfOntology) {
        if (dfOntology == null) {
            dfOntology = this.getKB().createOntology(URI.create("urn:owl-s-api:dataflow:Ontology" + System.nanoTime()));
        }
        for (Binding binding : this.getAllBindings()) {
            if (!binding.isValueOfBinding()) continue;
            ValueOf sourceParamValue = (ValueOf)binding.getValue();
            ProcessVar sourceParam = sourceParamValue.getTheVar();
            Object consParam = binding.getProcessVar();
            OWLType consParamType = consParam.getParamType();
            dfOntology.addProperty((OWLIndividual)sourceParam, OWLS_Extensions.Process.connectedTo, (OWLIndividual)consParam);
            OWLDataValue mssTypeDV = dfOntology.getProperty((OWLIndividual)sourceParam, OWLS_Extensions.Process.mssType);
            if (mssTypeDV == null) {
                dfOntology.addProperty((OWLIndividual)sourceParam, OWLS_Extensions.Process.mssType, consParamType.getURI());
                continue;
            }
            OWLType mssType = this.getKB().getType((URI)mssTypeDV.getValue());
            if (mssType.isSubTypeOf(consParamType) || consParamType.isSubTypeOf(OWL.Nothing)) continue;
            if (consParamType.isSubTypeOf(mssType)) {
                dfOntology.setProperty((OWLIndividual)sourceParam, OWLS_Extensions.Process.mssType, consParamType.getURI());
                continue;
            }
            logger.warn("Process {} with unsatisfiable data flow: Source variable ({}) has consumers of incompatible types {} and {}", new Object[]{this.getName0(), sourceParam, consParamType, mssType});
        }
        return new ProcessDataFlow(dfOntology);
    }

    @Override
    public boolean isInvocable() {
        OWLDataValue tmp = this.getProperty(OWLS_1_2.Process.invocable);
        if (tmp != null && tmp.getValue() instanceof Boolean) {
            return (Boolean)tmp.getValue();
        }
        boolean invocable = true;
        ControlConstruct composedOf = this.getComposedOf();
        OWLIndividualList<Process> processes = composedOf.getAllProcesses(true);
        for (Process p : processes) {
            if (!(p instanceof SimpleProcess)) continue;
            invocable = false;
            break;
        }
        this.setProperty(OWLS_1_2.Process.invocable, invocable);
        return invocable;
    }

    @Override
    public void setComputedEffect(Expression<?> expression) {
        this.setProperty(OWLS_1_2.Process.computedEffect, expression);
    }

    @Override
    public void setComputedInput(Expression<?> expression) {
        this.setProperty(OWLS_1_2.Process.computedInput, expression);
    }

    @Override
    public void setComputedOutput(Expression<?> expression) {
        this.setProperty(OWLS_1_2.Process.computedOutput, expression);
    }

    @Override
    public void setComputedPrecondition(Expression<?> expression) {
        this.setProperty(OWLS_1_2.Process.computedPrecondition, expression);
    }

    @Override
    protected void doPrepare(ExecutionContext context) {
        if (context.isCachingPermitted() && !(this.process instanceof CachedCompositeProcessImpl)) {
            this.process = new CachedCompositeProcessImpl(this.individual).prepare(context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CachedCompositeProcessImpl
    extends CompositeProcessImpl {
        private ControlConstruct body;
        private OWLIndividualList<Local> locals;
        private OWLIndividualList<Condition> preconditions;
        private OWLIndividualList<Result> results;

        public CachedCompositeProcessImpl(OWLIndividual ind) {
            super(ind);
        }

        @Override
        public ControlConstruct getComposedOf() {
            if (this.body == null) {
                this.body = super.getComposedOf();
            }
            return this.body;
        }

        @Override
        public void removeComposedOf() {
            this.body = null;
            super.removeComposedOf();
        }

        @Override
        public void setComposedOf(ControlConstruct construct) {
            this.body = null;
            super.setComposedOf(construct);
        }

        @Override
        public void addLocal(Local local) {
            this.locals = null;
            super.addLocal(local);
        }

        @Override
        public OWLIndividualList<Local> getLocals() {
            if (this.locals == null) {
                this.locals = super.getLocals();
            }
            return this.locals;
        }

        @Override
        public void removeLocal(Local local) {
            this.locals = null;
            super.removeLocal(local);
        }

        @Override
        public void addCondition(Condition<?> condition) {
            this.preconditions = null;
            super.addCondition(condition);
        }

        @Override
        public void addResult(Result result) {
            this.results = null;
            super.addResult(result);
        }

        @Override
        public Result createResult(URI uri) {
            this.results = null;
            return super.createResult(uri);
        }

        @Override
        public OWLIndividualList<Condition> getConditions() {
            if (this.preconditions == null) {
                this.preconditions = super.getConditions();
            }
            return this.preconditions;
        }

        @Override
        public OWLIndividualList<Result> getResults() {
            if (this.results == null) {
                this.results = super.getResults();
            }
            return this.results;
        }

        @Override
        public void removeCondition(Condition<?> condition) {
            this.preconditions = null;
            super.removeCondition(condition);
        }

        @Override
        public void removeResult(Result result) {
            this.results = null;
            super.removeResult(result);
        }

        @Override
        public CompositeProcessImpl prepare(ExecutionContext context) {
            this.getLocals();
            this.body = this.getComposedOf().prepare(context);
            return this;
        }

        @Override
        protected void doPrepare(ExecutionContext context) {
        }
    }
}

