/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process;

import impl.owls.process.ProcessImpl;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.InvalidOWLSException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.execution.ExecutionContext;
import org.mindswap.owls.process.execution.ExecutionSupport;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.utils.ProcessDataFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProcessImpl
extends ProcessImpl<SimpleProcessImpl>
implements SimpleProcess {
    public SimpleProcessImpl(OWLIndividual ind) {
        super(ind);
        this.process = this;
    }

    @Override
    public AtomicProcess getAtomicProcess() {
        return this.getPropertyAs(OWLS_1_2.Process.realizedBy, AtomicProcess.class);
    }

    @Override
    public CompositeProcess getCompositeProcess() {
        return this.getPropertyAs(OWLS_1_2.Process.expandsTo, CompositeProcess.class);
    }

    @Override
    public ProcessDataFlow getDataFlow(OWLOntology dfOntology) {
        Process p = this.getAtomicProcess();
        if (p != null) {
            return p.getDataFlow(dfOntology);
        }
        p = this.getCompositeProcess();
        if (p != null) {
            return p.getDataFlow(dfOntology);
        }
        throw new InvalidOWLSException("Simple process does neither expand to composite process nor is it realized by an atomic process.");
    }

    @Override
    public void removeAtomicProcess() {
        this.removeProperty(OWLS_1_2.Process.realizedBy, null);
    }

    @Override
    public void removeCompositeProcess() {
        this.removeProperty(OWLS_1_2.Process.expandsTo, null);
    }

    @Override
    public void setAtomicProcess(AtomicProcess process) {
        this.setProperty(OWLS_1_2.Process.realizedBy, process);
    }

    @Override
    public void setCompositeProcess(CompositeProcess process) {
        this.setProperty(OWLS_1_2.Process.expandsTo, process);
    }

    @Override
    public <C extends ExecutionContext> void execute(C context, ExecutionSupport<C> target) throws ExecutionException {
        target.executeSimpleProcess(this, context);
    }

    @Override
    protected void doPrepare(ExecutionContext context) {
        if (context.isCachingPermitted() && !(this.process instanceof CachedSimpleProcessImpl)) {
            this.process = new CachedSimpleProcessImpl(this.individual).prepare(context);
        }
    }

    static final class CachedSimpleProcessImpl
    extends SimpleProcessImpl {
        private Process proc;

        public CachedSimpleProcessImpl(OWLIndividual ind) {
            super(ind);
        }

        public AtomicProcess getAtomicProcess() {
            if (this.proc == null || this.proc instanceof CompositeProcess) {
                this.proc = super.getAtomicProcess();
            }
            return (AtomicProcess)this.proc;
        }

        public CompositeProcess getCompositeProcess() {
            if (this.proc == null || this.proc instanceof AtomicProcess) {
                this.proc = super.getCompositeProcess();
            }
            return (CompositeProcess)this.proc;
        }

        public void removeAtomicProcess() {
            this.proc = null;
            super.removeAtomicProcess();
        }

        public void removeCompositeProcess() {
            this.proc = null;
            super.removeCompositeProcess();
        }

        public void setAtomicProcess(AtomicProcess process) {
            this.proc = null;
            super.setAtomicProcess(process);
        }

        public void setCompositeProcess(CompositeProcess process) {
            this.proc = null;
            super.setCompositeProcess(process);
        }

        public SimpleProcessImpl prepare(ExecutionContext context) {
            AtomicProcess ap = this.getAtomicProcess();
            CompositeProcess cp = this.getCompositeProcess();
            if (ap != null && cp == null) {
                this.proc = ap.prepare(context);
            } else if (ap == null && cp != null) {
                this.proc = cp.prepare(context);
            }
            return this;
        }

        protected void doPrepare(ExecutionContext context) {
        }
    }
}

