/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.binding;

import impl.owl.WrappedIndividual;
import impl.owls.process.binding.ValueFunctionParser;
import org.mindswap.exceptions.ParseException;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.ParameterValue;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.owls.process.variable.ValueFunction;
import org.mindswap.owls.process.variable.ValueOf;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingImpl<V extends ProcessVar>
extends WrappedIndividual
implements Binding<V> {
    private static final Logger logger = LoggerFactory.getLogger(BindingImpl.class);

    public BindingImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public ParameterValue getValue() {
        ValueFunction<?> value = (ValueFunction<?>)((Object)this.getPropertyAs(OWLS_1_2.Process.valueSource, ValueOf.class));
        if (value != null) {
            return value;
        }
        OWLDataValue dataValue = this.getProperty(OWLS_1_2.Process.valueData);
        if (dataValue != null) {
            return this.getKB().createValueConstant(dataValue, this);
        }
        OWLIndividual owlValue = this.getProperty(OWLS_1_2.Process.valueObject);
        if (owlValue != null) {
            return this.getKB().createValueConstant(owlValue, this);
        }
        value = this.getValueFunction();
        return value;
    }

    @Override
    public boolean isValueConstantBinding() {
        return this.hasProperty(OWLS_1_2.Process.valueData);
    }

    @Override
    public boolean isValueFormBinding() {
        return this.hasProperty(OWLS_1_2.Process.valueForm);
    }

    @Override
    public boolean isValueFunctionBinding() {
        return this.hasProperty(OWLS_1_2.Process.valueFunction);
    }

    @Override
    public boolean isValueOfBinding() {
        return this.hasProperty(OWLS_1_2.Process.valueSource);
    }

    @Override
    public void setValue(ParameterValue paramValue) {
        if (paramValue == null) {
            throw new NullPointerException("Parameter value in Binding is null!");
        }
        paramValue.setToBinding(this);
    }

    @Override
    public String toString() {
        return "Bound process variable: " + this.getProcessVar() + ", Value description: " + this.getValue();
    }

    protected V setProcessVariable(V procVar) {
        if (procVar == null) {
            throw new NullPointerException("Process variable to set for Binding is null!");
        }
        Object old = this.getProcessVar();
        if (old != null) {
            this.removeProperty(OWLS_1_2.Process.toVar, (OWLValue)old);
        }
        this.setProperty(OWLS_1_2.Process.toVar, (OWLIndividual)procVar);
        return old;
    }

    private ValueFunction<?> getValueFunction() {
        OWLDataValue valueFunction = this.getProperty(OWLS_1_2.Process.valueFunction);
        String functionLiteral = valueFunction == null ? null : valueFunction.getLexicalValue();
        try {
            return new ValueFunctionParser(this).parse(functionLiteral);
        }
        catch (ParseException e) {
            logger.debug("Failed to parse value function. Details: {}", (Object)e.toString());
            return null;
        }
    }
}

