/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.binding;

import java.util.Map;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.ParameterValueVisitor;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.owls.process.variable.ValueConstant;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueConstantImpl
implements ValueConstant {
    private static final Logger logger = LoggerFactory.getLogger(ValueConstantImpl.class);
    private OWLDataValue dataValue;
    private OWLIndividual individualValue;
    private final Binding<?> enclosingBinding;

    public ValueConstantImpl(OWLValue constantValue, Binding<?> enclosingBinding) {
        OWLType paramType;
        this.enclosingBinding = enclosingBinding;
        if (constantValue == null) {
            throw new IllegalArgumentException("Value is null for ValueConstant!");
        }
        Object param = enclosingBinding.getProcessVar();
        OWLType oWLType = paramType = param == null ? null : param.getParamType();
        if (constantValue.isIndividual()) {
            if (paramType != null && paramType.isDataType()) {
                throw new IllegalArgumentException("Can not bind constant individual to process variable that is typed to datatype.");
            }
            this.dataValue = null;
            this.individualValue = (OWLIndividual)constantValue;
        } else {
            if (paramType != null && paramType.isClass()) {
                throw new IllegalArgumentException("Can not bind constant data value to process variable that is typed to OWL class.");
            }
            this.dataValue = (OWLDataValue)constantValue;
            this.individualValue = null;
        }
    }

    @Override
    public void accept(ParameterValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OWLDataValue getData() {
        return this.dataValue;
    }

    @Override
    public OWLIndividual getIndividual() {
        return this.individualValue;
    }

    public Object getImplementation() {
        return (this.dataValue != null ? this.dataValue : this.individualValue).getImplementation();
    }

    @Override
    public Binding<?> getEnclosingBinding() {
        return this.enclosingBinding;
    }

    @Override
    public void setToBinding(Binding<?> binding) {
        OWLType paramType;
        Object param = binding.getProcessVar();
        OWLType oWLType = paramType = param == null ? null : param.getParamType();
        if (this.dataValue != null) {
            if (paramType != null && paramType.isClass()) {
                logger.warn("Binding conflict in {}: Do not bind constant data value to process variable {} typed to OWL class.", binding, param);
            }
            binding.setProperty(OWLS_1_2.Process.valueData, this.dataValue);
            binding.removeProperty(OWLS_1_2.Process.valueObject, null);
        } else {
            if (paramType != null && paramType.isDataType()) {
                logger.warn("Binding conflict in {}: Do not bind constant individual to process variable {} typed to data type.", binding, param);
            }
            binding.setProperty(OWLS_1_2.Process.valueObject, this.individualValue);
            binding.removeProperty(OWLS_1_2.Process.valueData, null);
        }
    }

    @Override
    public OWLValue getValueFromPerformResults(Map<Perform, ValueMap<ProcessVar, OWLValue>> performResults) {
        return this.dataValue != null ? this.dataValue : this.individualValue;
    }

    @Override
    public boolean isDataValue() {
        return this.dataValue != null;
    }

    @Override
    public boolean isIndividualValue() {
        return this.individualValue != null;
    }

    public String toString() {
        return ValueConstant.class.getSimpleName() + ": " + (this.dataValue != null ? this.dataValue : this.individualValue);
    }
}

