/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.binding;

import org.mindswap.common.Parser;
import org.mindswap.exceptions.CastingException;
import org.mindswap.exceptions.ParseException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.ValueFunction;
import org.mindswap.utils.RDFUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValueFunctionParser
implements Parser<String, ValueFunction<?>> {
    private final Binding<?> binding;

    ValueFunctionParser(Binding<?> binding) {
        this.binding = binding;
    }

    @Override
    public ValueFunction<?> parse(String input) throws ParseException {
        if (input == null) {
            throw new ParseException((Object)input, "Value function literal null.");
        }
        input = RDFUtils.addRDFTag(input.trim());
        OWLIndividual function = this.binding.getOntology().parseLiteral(input);
        try {
            Expression.SPARQL expression = function.castTo(Expression.SPARQL.class);
            return this.binding.getOntology().createSPARQLValueFunction(expression, this.binding);
        }
        catch (CastingException e) {
            throw new ParseException((Object)input, "Unsupported value function. Only SPARQL expressions are currently supported.");
        }
    }
}

