/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.execution;

import impl.owls.process.execution.ProcessExecutionUtil;
import impl.owls.process.execution.StandardExecutionValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mindswap.exceptions.UnsatisfiedPreconditionException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AsProcess;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Set;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.execution.BaseExecutionContext;
import org.mindswap.owls.process.execution.ExecutionSupport;
import org.mindswap.owls.process.execution.ExecutionValidator;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.execution.ProcessExecutionMonitor;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.InputBinding;
import org.mindswap.owls.process.variable.Loc;
import org.mindswap.owls.process.variable.LocBinding;
import org.mindswap.owls.process.variable.Local;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.Parameter;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.owls.process.variable.ValueOf;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecutionEngineImpl
implements ProcessExecutionEngine,
ExecutionSupport<BaseExecutionContext> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessExecutionEngineImpl.class);
    protected boolean caching = true;
    protected final AtomicBoolean working;
    protected ExecutionValidator executionValidator = new StandardExecutionValidator();
    protected final List<ProcessExecutionMonitor> monitors = new CopyOnWriteArrayList<ProcessExecutionMonitor>();
    protected OWLKnowledgeBase env;
    protected Process process;
    protected final Map<Perform, ValueMap<ProcessVar, OWLValue>> performResults = new HashMap<Perform, ValueMap<ProcessVar, OWLValue>>();

    public ProcessExecutionEngineImpl() {
        this.working = new AtomicBoolean(false);
    }

    @Override
    public ExecutionValidator getExecutionValidator() {
        return this.executionValidator;
    }

    @Override
    public ExecutionValidator setExecutionValidator(ExecutionValidator ev) {
        if (this.working.get()) {
            throw new IllegalStateException("Setting the execution validator is forbidden while an execution is on the way.");
        }
        ExecutionValidator previous = this.executionValidator;
        this.executionValidator = ev;
        return previous;
    }

    @Override
    public boolean setCaching(boolean caching) {
        if (this.working.get()) {
            throw new IllegalStateException("Setting caching policy is forbidden while an execution is on the way.");
        }
        boolean previous = caching;
        this.caching = caching;
        return previous;
    }

    @Override
    public boolean addMonitor(ProcessExecutionMonitor monitor) {
        return this.monitors.add(monitor);
    }

    @Override
    public boolean removeMonitor(ProcessExecutionMonitor monitor) {
        return this.monitors.remove(monitor);
    }

    protected org.mindswap.exceptions.ExecutionException executionFailed(String msg) {
        return this.executionFailed(new org.mindswap.exceptions.ExecutionException(msg, this.process));
    }

    protected org.mindswap.exceptions.ExecutionException executionFailed(Exception e) {
        return this.executionFailed(new org.mindswap.exceptions.ExecutionException(e, this.process));
    }

    protected org.mindswap.exceptions.ExecutionException executionFailed(org.mindswap.exceptions.ExecutionException e) {
        for (ProcessExecutionMonitor monitor : this.monitors) {
            monitor.executionFailed(e);
        }
        return e;
    }

    protected boolean passFilter(ProcessExecutionMonitor monitor, Process p) {
        int processType = 7;
        processType = p instanceof AtomicProcess ? 1 : (p instanceof CompositeProcess ? 2 : 4);
        return (processType & monitor.getMonitorFilter()) != 0;
    }

    protected void executionStarted(Process p, ValueMap<Input, OWLValue> inputs) {
        for (ProcessExecutionMonitor monitor : this.monitors) {
            if (!this.passFilter(monitor, p)) continue;
            monitor.executionStarted(p, inputs);
        }
    }

    protected void executionFinished(Process p, ValueMap<Input, OWLValue> inputs, ValueMap<Output, OWLValue> outputs) {
        for (ProcessExecutionMonitor monitor : this.monitors) {
            if (!this.passFilter(monitor, p)) continue;
            monitor.executionFinished(p, inputs, outputs);
        }
    }

    protected void executionStarted() {
        for (ProcessExecutionMonitor monitor : this.monitors) {
            monitor.executionStarted();
        }
    }

    protected void executionFinished() {
        for (ProcessExecutionMonitor monitor : this.monitors) {
            monitor.executionFinished();
        }
    }

    protected void init(Process p, OWLKnowledgeBase kb) {
        this.env = kb != null ? kb : p.getKB();
        this.process = p;
        this.working.set(true);
    }

    protected void cleanup() {
        this.env = null;
        this.process = null;
        this.performResults.clear();
        this.working.set(false);
    }

    @Override
    public ValueMap<Output, OWLValue> execute(Process p, OWLKnowledgeBase kb) throws org.mindswap.exceptions.ExecutionException {
        return this.execute(p, new ValueMap<Input, OWLValue>(), kb);
    }

    @Override
    public ValueMap<Output, OWLValue> execute(Process p, ValueMap<Input, OWLValue> inputs, OWLKnowledgeBase kb) throws org.mindswap.exceptions.ExecutionException {
        this.init(p, kb);
        try {
            this.executionStarted(p, inputs);
            BaseExecutionContext context = new BaseExecutionContext(this.caching);
            context.addInputs(inputs, false);
            p.prepare(context).execute(context, this);
            ValueMap<Output, OWLValue> results = context.getOutputs();
            this.executionFinished(p, inputs, results);
            ValueMap<Output, OWLValue> valueMap = results;
            return valueMap;
        }
        catch (org.mindswap.exceptions.ExecutionException e) {
            throw this.executionFailed(e);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public ValueMap<Output, OWLValue> execute(Perform p, OWLKnowledgeBase kb) throws org.mindswap.exceptions.ExecutionException {
        ValueMap<Output, OWLValue> results;
        this.init(p.getProcess(), kb);
        BaseExecutionContext context = new BaseExecutionContext(this.caching);
        try {
            p.execute(context, this);
            results = context.getOutputs();
            this.executionFinished(this.process, context.getInputs(), results);
        }
        catch (org.mindswap.exceptions.ExecutionException e) {
            throw this.executionFailed(e);
        }
        finally {
            this.cleanup();
        }
        return results;
    }

    @Override
    public void executeAtomicProcess(AtomicProcess p, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        this.executionValidator.checkPreconditions(p, context.getValues(), this.env);
        AtomicGrounding<?> grounding = p.getGrounding();
        if (grounding == null) {
            throw new org.mindswap.exceptions.ExecutionException("No grounding for " + p);
        }
        logger.debug("Executing atomic process {} by invoking {}", (Object)this.process, grounding);
        Future<ValueMap<Output, OWLValue>> f = grounding.invoke(context.getInputs(), this.env);
        try {
            context.addOutputs(f.get(), false);
        }
        catch (InterruptedException e) {
            throw new org.mindswap.exceptions.ExecutionException(e);
        }
        catch (ExecutionException e) {
            throw new org.mindswap.exceptions.ExecutionException(e);
        }
        this.executionValidator.checkResults(p, context.getValues(), this.env);
    }

    @Override
    public void executeCompositeProcess(CompositeProcess cp, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        this.initializeLocals(cp, context);
        ValueMap<ProcessVar, OWLValue> values = context.getValues();
        this.executionValidator.checkPreconditions(cp, values, this.env);
        cp.getComposedOf().execute(context, this);
        OWLIndividualList<Result> results = cp.getResults();
        if (results.size() > 0) {
            ProcessExecutionUtil.processValues(this.performResults, values, values, ((Result)results.get(0)).getBindings());
        }
        this.executionValidator.checkResults(cp, values, this.env);
    }

    @Override
    public void executeSimpleProcess(SimpleProcess sp, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        AtomicProcess ap = sp.getAtomicProcess();
        CompositeProcess cp = sp.getCompositeProcess();
        if (ap != null && cp == null) {
            ap.execute(context, this);
        } else if (ap == null && cp != null) {
            cp.execute(context, this);
        } else {
            throw new org.mindswap.exceptions.ExecutionException("SimpleProcess must be either realized by AtomicProcess xor expand to CompositeProcess, but not both or neither of them.");
        }
    }

    @Override
    public void executePerform(Perform perform, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        Process performProcess = perform.getProcess();
        if (performProcess == null) {
            throw this.executionFailed("Invalid: Perform " + perform + " without process!");
        }
        ValueMap<ProcessVar, OWLValue> values = new ValueMap<ProcessVar, OWLValue>();
        OWLIndividualList<InputBinding> bindings = perform.getBindings();
        ProcessExecutionUtil.processValues(this.performResults, context.getValues(), values, bindings);
        BaseExecutionContext newContext = new BaseExecutionContext(values, this.caching);
        this.executionStarted(performProcess, newContext.getInputs());
        try {
            performProcess.execute(newContext, this);
            this.executionFinished(performProcess, newContext.getInputs(), newContext.getOutputs());
        }
        catch (org.mindswap.exceptions.ExecutionException e) {
            this.executionFailed(e);
            throw e;
        }
        finally {
            this.performResults.put(perform, newContext.getValues());
        }
    }

    @Override
    public void executeProduce(Produce produce, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        ValueMap<ProcessVar, OWLValue> thisPerformValues = context.getValues();
        OWLIndividualList<Binding<Output>> bindings = produce.getOutputBindings();
        ProcessExecutionUtil.processValues(this.performResults, thisPerformValues, thisPerformValues, bindings);
        bindings = produce.getLinkBindings();
        ProcessExecutionUtil.processValues(this.performResults, thisPerformValues, thisPerformValues, bindings);
    }

    @Override
    public void executeSequence(Sequence seq, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        OWLIndividualList<ControlConstruct> ccList = seq.getConstructs();
        for (ControlConstruct cc : ccList) {
            cc.execute(context, this);
        }
    }

    @Override
    public void executeSet(Set set, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        OWLIndividualList<LocBinding> assignments = set.getBindings();
        ValueMap<ProcessVar, OWLValue> thisPerformValues = context.getValues();
        ProcessExecutionUtil.processValues(this.performResults, thisPerformValues, thisPerformValues, assignments);
    }

    @Override
    public void executeAnyOrder(AnyOrder ao, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        OWLIndividualList<ControlConstruct> queue = ao.getConstructs();
        int i = 0;
        while (queue.size() > 0) {
            ControlConstruct cc = (ControlConstruct)queue.remove(0);
            ++i;
            try {
                cc.execute(context, this);
                i = 0;
            }
            catch (UnsatisfiedPreconditionException e) {
                queue.add(cc);
                if (i >= queue.size()) {
                    logger.debug("No execution progress for AnyOrder because of unsatisfied preconditions. Exeception will be propagated upwards.");
                    throw e;
                }
                logger.debug("Reschedule execution of control construct {} in AnyOrder because of unsatisfied precondition.", (Object)cc);
            }
        }
    }

    @Override
    public void executeAsProcess(AsProcess ap, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        throw new UnsupportedOperationException("Execution of AsProcess constructs is not yet supported.");
    }

    @Override
    public void executeChoice(Choice choice, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        OWLIndividualList<ControlConstruct> ccList = choice.getConstructs();
        List<Integer> indexes = ProcessExecutionUtil.createRandomIntegers(ccList.size(), new int[0]);
        boolean notDone = true;
        while (indexes.size() > 0 && notDone) {
            int index = indexes.remove(0);
            ControlConstruct cc = (ControlConstruct)ccList.get(index);
            try {
                cc.execute(context, this);
                notDone = false;
            }
            catch (UnsatisfiedPreconditionException e) {
                if (indexes.isEmpty()) {
                    logger.debug("Unsatisifed precondition in Choice and no alternative left. Exception will be propagated upwards.");
                    throw e;
                }
                logger.debug("Discard choice construct {} because its precondition(s) are not satisfied. Trying to execute next choice now.", (Object)cc);
            }
        }
    }

    @Override
    public void executeIfThenElse(IfThenElse ifThenElse, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        Condition<?> ifCondition = ifThenElse.getCondition();
        ControlConstruct thenCC = ifThenElse.getThen();
        ControlConstruct elseCC = ifThenElse.getElse();
        if (this.isTrue(ifCondition, context.getValues())) {
            thenCC.execute(context, this);
        } else if (elseCC != null) {
            elseCC.execute(context, this);
        }
    }

    @Override
    public void executeRepeatWhile(RepeatWhile cc, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        Condition<?> whileCondition = cc.getCondition();
        ControlConstruct loopBody = cc.getComponent();
        while (this.isTrue(whileCondition, context.getValues())) {
            loopBody.execute(context, this);
        }
    }

    @Override
    public void executeRepeatUntil(RepeatUntil cc, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        Condition<?> repeatCondition = cc.getCondition();
        ControlConstruct loopBody = cc.getComponent();
        do {
            loopBody.execute(context, this);
        } while (this.isTrue(repeatCondition, context.getValues()));
    }

    @Override
    public void executeForEach(ForEach fe, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        ValueMap<ProcessVar, OWLValue> thisPerformValues = context.getValues();
        ControlConstruct loopBody = fe.getComponent();
        Loc loopVar = fe.getLoopVar();
        ValueOf valueOf = fe.getListValue();
        Perform otherPerform = valueOf.getPerform();
        Parameter otherParam = valueOf.getParameter();
        ValueMap<ProcessVar, OWLValue> performValues = OWLS_1_2.Process.ThisPerform.equals(otherPerform) ? thisPerformValues : this.performResults.get(otherPerform);
        if (performValues == null) {
            throw this.executionFailed("Process variable value mappings of perform " + otherPerform + " not found! This is likely caused by an invalid data flow specification inside " + fe);
        }
        OWLIndividual ind = performValues.getIndividualValue(otherParam);
        OWLList<OWLValue> list = ind.castToList(RDF.ListVocabulary);
        for (OWLValue value : list) {
            thisPerformValues.setValue(loopVar, value);
            loopBody.execute(context, this);
        }
    }

    @Override
    public void executeSplit(Split split, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        this.executeParallel(split.getConstructs(), context, false);
    }

    @Override
    public void executeSplitJoin(SplitJoin splitJoint, BaseExecutionContext context) throws org.mindswap.exceptions.ExecutionException {
        this.executeParallel(splitJoint.getConstructs(), context, true);
    }

    protected void initializeLocals(CompositeProcess cp, BaseExecutionContext context) {
        ValueMap<Local, OWLValue> locals = new ValueMap<Local, OWLValue>();
        for (Local local : cp.getLocals()) {
            OWLValue initialValue;
            if (!(local instanceof Loc) || (initialValue = ((Loc)local).getInitialValue()) == null) continue;
            locals.setValue(local, initialValue);
        }
        context.addLocals(locals, false);
    }

    protected boolean isTrue(Condition<?> condition, ValueMap<ProcessVar, OWLValue> binding) {
        return condition.isTrue(this.env, binding);
    }

    protected void executeParallel(OWLIndividualList<ControlConstruct> constructs, BaseExecutionContext context, boolean join) throws org.mindswap.exceptions.ExecutionException {
        ArrayList<ProcessExecutionThread> threads = new ArrayList<ProcessExecutionThread>();
        for (ControlConstruct construct : constructs) {
            String name = construct.getLocalName();
            name = name == null ? construct.getConstructName() : name;
            name = name + " execution thread";
            ProcessExecutionThread t = new ProcessExecutionThread(construct, context, name);
            threads.add(t);
            logger.debug("Starting {} ...", (Object)t.getName());
            t.start();
        }
        if (join) {
            HashSet<Exception> exceptions = new HashSet<Exception>();
            for (ProcessExecutionThread t : threads) {
                try {
                    logger.debug("Waiting for {} to finish...", (Object)t.getName());
                    t.join();
                    Exception ee = t.exception;
                    logger.debug("{} finished {}", (Object)t.getName(), (Object)(ee == null ? "successfully" : "with exception " + ee.toString()));
                    if (ee == null) continue;
                    exceptions.add(ee);
                }
                catch (InterruptedException e) {
                    exceptions.add(e);
                    throw this.executionFailed(e);
                }
            }
            if (exceptions.size() > 0) {
                throw new org.mindswap.exceptions.ExecutionException(exceptions);
            }
        }
    }

    private final class ProcessExecutionThread
    extends Thread {
        final BaseExecutionContext context;
        final ControlConstruct cc;
        Exception exception;

        ProcessExecutionThread(ControlConstruct cc, BaseExecutionContext context, String name) {
            super(name);
            this.cc = cc;
            this.context = context;
        }

        public void run() {
            try {
                this.cc.execute(this.context, ProcessExecutionEngineImpl.this);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

