/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.exceptions.DataFlowException;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.Loc;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecutionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProcessExecutionUtil.class);

    public static final List<Integer> createRandomIntegers(int n, int ... exclude) {
        ArrayList<Integer> integers = new ArrayList<Integer>(n);
        ArrayList<Integer> excludes = new ArrayList<Integer>(exclude.length);
        for (int e : exclude) {
            excludes.add(e);
        }
        int i = 0;
        while (integers.size() < n) {
            Integer integer;
            if (excludes.remove(integer = Integer.valueOf(i++))) continue;
            integers.add(integer);
        }
        Collections.shuffle(integers);
        return integers;
    }

    public static final void processValues(Map<Perform, ValueMap<ProcessVar, OWLValue>> performResults, ValueMap<ProcessVar, OWLValue> thisPerform, ValueMap<ProcessVar, OWLValue> targetPerform, List<? extends Binding<?>> bindings) throws DataFlowException {
        HashMap<Perform, ValueMap<ProcessVar, OWLValue>> allPerforms = new HashMap<Perform, ValueMap<ProcessVar, OWLValue>>(performResults);
        allPerforms.put(OWLS_1_2.Process.ThisPerform, thisPerform);
        for (Binding<?> binding : bindings) {
            OWLValue paramValue;
            Object procVar = binding.getProcessVar();
            OWLValue prevValue = targetPerform.setValue((ProcessVar)procVar, paramValue = binding.getValue().getValueFromPerformResults(allPerforms));
            if (prevValue == null) continue;
            if (procVar instanceof Loc) {
                logger.debug("Local variable {} reassigned with new value. Previous value disposed.", procVar);
                continue;
            }
            throw new DataFlowException("Attempt to reassign process variable " + procVar + ", which is forbidden for write-once variables such as Link and other non-local " + "variables. This is likely caused by an invalid data flow specification.");
        }
    }
}

