/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.execution;

import java.util.Map;
import org.mindswap.common.ClosableIterator;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.MultipleSatisfiedPreconditionException;
import org.mindswap.exceptions.PreconditionException;
import org.mindswap.exceptions.ResultException;
import org.mindswap.exceptions.UnsatisfiedPreconditionException;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.execution.ExecutionValidator;
import org.mindswap.owls.process.variable.Existential;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.query.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardExecutionValidator
implements ExecutionValidator {
    private static final Logger logger = LoggerFactory.getLogger(StandardExecutionValidator.class);
    private boolean allowMultipleSatisifedPreconditions = true;
    private boolean checkPreconditions = true;
    private boolean checkResults = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPreconditions(Process process, ValueMap<ProcessVar, OWLValue> values, OWLKnowledgeBase kb) throws PreconditionException {
        OWLIndividualList<Condition> preconditions;
        if (this.checkPreconditions && (preconditions = process.getConditions()).size() > 0) {
            String processName = this.getProcessName(process);
            OWLIndividualList<Existential> existentials = process.getExistentials();
            for (Condition cond : preconditions) {
                logger.debug("Checking precondition {} of process {}.", (Object)cond, (Object)processName);
                ClosableIterator<ValueMap<Existential, OWLValue>> results = cond.solutions(values, existentials);
                try {
                    if (results.hasNext()) {
                        ValueMap result = (ValueMap)results.next();
                        if (results.hasNext() && !this.allowMultipleSatisifedPreconditions) {
                            throw new MultipleSatisfiedPreconditionException(process, cond);
                        }
                        for (Map.Entry entry : result) {
                            Existential var = (Existential)entry.getKey();
                            values.setValue(var, (OWLValue)entry.getValue());
                        }
                        continue;
                    }
                    throw new UnsatisfiedPreconditionException(process, cond);
                }
                finally {
                    results.close();
                }
            }
        }
    }

    @Override
    public void checkResults(Process process, ValueMap<ProcessVar, OWLValue> values, OWLKnowledgeBase kb) throws ExecutionException {
        OWLIndividualList<Result> results;
        if (this.checkResults && (results = process.getResults()).size() > 0) {
            String processName = this.getProcessName(process);
            block0: for (Result result : results) {
                for (Condition c : result.getConditions()) {
                    if (c.isTrue(kb, values)) continue;
                    logger.debug("Condition {} of result {} in process {} not satisifed. Result effect(s) not applied to KB.", new Object[]{c, result, processName});
                    continue block0;
                }
                for (Expression effect : result.getEffects()) {
                    logger.debug("Applying effect {} declared by result {} of process {} to KB.", new Object[]{effect, result, processName});
                    effect.evaluate(values);
                }
                if (kb.isConsistent()) continue;
                throw new ResultException("Inconsistent KB after applying effect(s) declared by result " + result + " of process " + processName + " to KB.", result);
            }
        }
    }

    @Override
    public boolean isAllowMultipleSatisifedPreconditions() {
        return this.allowMultipleSatisifedPreconditions;
    }

    @Override
    public boolean isPreconditionCheck() {
        return this.checkPreconditions;
    }

    @Override
    public boolean isResultCheck() {
        return this.checkResults;
    }

    @Override
    public void setAllowMultipleSatisfiedPreconditions(boolean allowMultipleSatisifedPreconditions) {
        this.allowMultipleSatisifedPreconditions = allowMultipleSatisifedPreconditions;
    }

    @Override
    public void setPreconditionCheck(boolean checkPreconditions) {
        this.checkPreconditions = checkPreconditions;
    }

    @Override
    public void setResultCheck(boolean checkResults) {
        this.checkResults = checkResults;
    }

    public String toString() {
        return "Precondition check: " + this.checkPreconditions + ", Result check: " + this.checkResults + ", Allow multiple satisfied preconditions: " + this.allowMultipleSatisifedPreconditions;
    }

    private String getProcessName(Process p) {
        String pn = p.getName();
        pn = pn != null ? pn : (p.isAnon() ? p.getAnonID() : p.getURI().toString());
        return pn;
    }
}

