/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.service;

import impl.owl.WrappedIndividual;
import java.util.List;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl
extends WrappedIndividual
implements Service {
    public ServiceImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public void addGrounding(Grounding<?, ?> grounding) {
        this.addProperty(OWLS_1_2.Service.supports, grounding);
        grounding.setService(this);
    }

    @Override
    public void addProfile(Profile profile) {
        this.addProperty(OWLS_1_2.Service.presents, profile);
        profile.setService(this);
    }

    @Override
    public void addProvider(OWLIndividual provider) {
        this.addProperty(OWLS_1_2.Service.providedBy, provider);
        provider.addProperty(OWLS_1_2.Service.provides, this);
    }

    @Override
    public Grounding<?, ?> getGrounding() {
        return this.getPropertyAs(OWLS_1_2.Service.supports, Grounding.class);
    }

    @Override
    public OWLIndividualList<Grounding> getGroundings() {
        return this.getPropertiesAs(OWLS_1_2.Service.supports, Grounding.class);
    }

    @Override
    public String getName() {
        Profile profile = this.getProfile();
        return profile == null ? null : profile.getServiceName();
    }

    @Override
    public String getName(String lang) {
        Profile profile = this.getProfile();
        return profile == null ? null : profile.getServiceName(lang);
    }

    @Override
    public List<OWLDataValue> getNames() {
        Profile profile = this.getProfile();
        return profile == null ? null : profile.getServiceNames();
    }

    @Override
    public Process getProcess() {
        return this.getPropertyAs(OWLS_1_2.Service.describedBy, Process.class);
    }

    @Override
    public Profile getProfile() {
        return this.getPropertyAs(OWLS_1_2.Service.presents, Profile.class);
    }

    @Override
    public OWLIndividualList<Profile> getProfiles() {
        return this.getPropertiesAs(OWLS_1_2.Service.presents, Profile.class);
    }

    @Override
    public OWLIndividualList<?> getProviders() {
        return this.getProperties(OWLS_1_2.Service.providedBy);
    }

    @Override
    public void removeGrounding(Grounding<?, ?> grounding) {
        if (this.hasProperty(OWLS_1_2.Service.supports, grounding)) {
            if (grounding != null) {
                this.removeProperty(OWLS_1_2.Service.supports, grounding);
                grounding.removeService();
            } else {
                for (Grounding g : this.getGroundings()) {
                    this.removeProperty(OWLS_1_2.Service.supports, g);
                    g.removeService();
                }
            }
        }
    }

    @Override
    public void removeProcess() {
        if (this.hasProperty(OWLS_1_2.Service.describedBy)) {
            Process process = this.getProcess();
            this.removeProperty(OWLS_1_2.Service.describedBy, null);
            if (process != null) {
                process.removeService();
            }
        }
    }

    @Override
    public void removeProfile(Profile profile) {
        if (this.hasProperty(OWLS_1_2.Service.presents, profile)) {
            if (profile != null) {
                this.removeProperty(OWLS_1_2.Service.presents, profile);
                profile.removeService();
            } else {
                for (Profile p : this.getProfiles()) {
                    this.removeProperty(OWLS_1_2.Service.presents, p);
                    p.removeService();
                }
            }
        }
    }

    @Override
    public void removeProvider(OWLIndividual provider) {
        this.removeProperty(OWLS_1_2.Service.providedBy, provider);
    }

    @Override
    public void setName(String name) {
        Profile profile = this.getProfile();
        if (profile != null) {
            profile.setServiceName(name);
        }
    }

    @Override
    public void setProcess(Process process) {
        if (this.hasProperty(OWLS_1_2.Service.describedBy, process)) {
            return;
        }
        this.setProperty(OWLS_1_2.Service.describedBy, process);
        process.setService(this);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Service    ");
        Object o = this.getLabel(null);
        if (o != null) {
            str.append(o).append(" ");
        }
        if ((o = this.getURI()) != null) {
            str.append(o);
        }
        str.append(Utils.LINE_SEPARATOR);
        str.append("Profiles   ").append(this.getProfiles()).append(Utils.LINE_SEPARATOR);
        str.append("Process    ").append(this.getProcess()).append(Utils.LINE_SEPARATOR);
        str.append("Groundings ").append(this.getGroundings()).append(Utils.LINE_SEPARATOR);
        return str.toString();
    }
}

