/*
 * Decompiled with CFR 0.152.
 */
package impl.swrl;

import impl.swrl.AtomImpl;
import java.util.HashMap;
import java.util.Map;
import org.mindswap.exceptions.InvalidOWLSException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomVisitor;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinAtomImpl
extends AtomImpl
implements BuiltinAtom {
    private static final int MANY = -1;
    private static final Map<OWLIndividual, Integer> ARG_COUNT = new HashMap<OWLIndividual, Integer>(9);

    public BuiltinAtomImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public void accept(AtomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Atom apply(ValueMap<?, ?> binding, SWRLFactory.ISWRLFactory swrlFactory) {
        OWLIndividual builtin = this.getBuiltin();
        if (builtin == null) {
            throw new InvalidOWLSException("SWRL BuiltinAtom is missing builtin property.");
        }
        OWLList<SWRLDataObject> args = this.getArguments();
        int count = this.getArgumentCount(builtin);
        count = count == -1 ? args.size() : count;
        OWLValue[] argsArr = new SWRLDataObject[count];
        count = 0;
        for (SWRLDataObject arg : args) {
            argsArr[count] = this.getDataObject(arg, binding, swrlFactory);
            ++count;
        }
        return swrlFactory.createBuiltinAtom(builtin, argsArr);
    }

    @Override
    public OWLIndividual getBuiltin() {
        return this.getProperty(SWRL.builtin);
    }

    @Override
    public void setBuiltin(OWLIndividual builtin) {
        this.setProperty(SWRL.builtin, builtin);
    }

    @Override
    public int getArgumentCount() {
        return this.getArgumentCount(this.getBuiltin());
    }

    @Override
    public OWLList<SWRLDataObject> getArguments() {
        OWLIndividual args = this.getOntology().getProperty((OWLIndividual)this, SWRL.arguments);
        return args == null ? this.getOntology().createList(SWRLB.BuiltInArgsListVocabulary) : args.castToList(SWRLB.BuiltInArgsListVocabulary);
    }

    @Override
    public SWRLDataObject getArgument(int index) {
        OWLList<SWRLDataObject> args = this.getArguments();
        return args.get(index);
    }

    @Override
    public void addArgument(SWRLDataObject arg) {
        OWLList<SWRLDataObject> args = this.getArguments();
        if (args.isEmpty()) {
            args = args.with(arg);
            this.setProperty(SWRL.arguments, args);
        } else {
            args.with(arg);
        }
    }

    @Override
    public void setArgument(int index, SWRLObject arg) {
        if (!(arg instanceof SWRLDataObject)) {
            throw new IllegalArgumentException(BuiltinAtom.class.getSimpleName() + " argument should be a " + SWRLDataObject.class.getSimpleName());
        }
        OWLList<SWRLDataObject> args = this.getArguments();
        args.set(index, (SWRLDataObject)arg);
    }

    @Override
    public String toString() {
        OWLIndividual builtin = this.getBuiltin();
        if (builtin == null) {
            return "Missing_class_predicate";
        }
        StringBuilder str = new StringBuilder("(").append(this.getArgument(0));
        if (builtin.equals(SWRLB.equal)) {
            str.append(" = ").append(this.getArgument(1));
        } else if (builtin.equals(SWRLB.lessThan)) {
            str.append(" < ").append(this.getArgument(1));
        } else if (builtin.equals(SWRLB.greaterThan)) {
            str.append(" > ").append(this.getArgument(1));
        } else if (builtin.equals(SWRLB.subtract)) {
            str.append(" = ").append(this.getArgument(1)).append(" - ").append(this.getArgument(2));
        } else if (builtin.equals(SWRLB.divide)) {
            str.append(" = ").append(this.getArgument(1)).append(" / ").append(this.getArgument(2));
        } else if (builtin.equals(SWRLB.mod)) {
            str.append(" = ").append(this.getArgument(1)).append(" % ").append(this.getArgument(2));
        } else if (builtin.equals(SWRLB.pow)) {
            str.append(" = ").append(this.getArgument(1)).append(" ^ ").append(this.getArgument(2));
        } else {
            str.insert(0, builtin.getLocalName());
            for (SWRLDataObject arg : this.getArguments()) {
                str.append(", ");
                str.append(arg);
            }
        }
        str.append(")");
        return str.toString();
    }

    @Override
    public void evaluate(ValueMap<?, ?> values) {
        throw new UnsupportedOperationException("Builtin SWRL atoms cannot be evaluated.");
    }

    private int getArgumentCount(OWLIndividual builtin) {
        Integer count = ARG_COUNT.get(builtin);
        return count != null ? count : 2;
    }

    static {
        ARG_COUNT.put(SWRLB.add, -1);
        ARG_COUNT.put(SWRLB.subtract, 3);
        ARG_COUNT.put(SWRLB.multiply, -1);
        ARG_COUNT.put(SWRLB.divide, 3);
        ARG_COUNT.put(SWRLB.mod, 3);
        ARG_COUNT.put(SWRLB.pow, 3);
    }
}

