/*
 * Decompiled with CFR 0.152.
 */
package impl.swrl;

import impl.swrl.AtomImpl;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomVisitor;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLDataValue;
import org.mindswap.swrl.SWRLDataVariable;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.SWRLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPropertyAtomImpl
extends AtomImpl
implements DataPropertyAtom {
    public DataPropertyAtomImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public void accept(AtomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Atom apply(ValueMap<?, ?> binding, SWRLFactory.ISWRLFactory swrlFactory) {
        return swrlFactory.createDataPropertyAtom(this.getPropertyPredicate(), this.getIndidividualObject(this.getArgument1(), binding, swrlFactory), this.getDataObject(this.getArgument2(), binding, swrlFactory));
    }

    @Override
    public OWLDataProperty getPropertyPredicate() {
        return this.getPropertyAs(SWRL.propertyPredicate, OWLDataProperty.class);
    }

    @Override
    public void setPropertyPredicate(OWLDataProperty p) {
        this.setProperty(SWRL.propertyPredicate, p.castTo(OWLIndividual.class));
    }

    @Override
    public SWRLIndividualObject getArgument1() {
        return this.getPropertyAs(SWRL.argument1, SWRLIndividualObject.class);
    }

    @Override
    public SWRLDataObject getArgument2() {
        SWRLDataObject arg = this.getPropertyAs(SWRL.argument2, SWRLDataVariable.class);
        if (arg == null) {
            arg = this.getPropertyAs(SWRL._argument2, SWRLDataValue.class);
        }
        return arg;
    }

    @Override
    public int getArgumentCount() {
        return 2;
    }

    @Override
    public SWRLObject getArgument(int index) {
        if (index == 0) {
            return this.getArgument1();
        }
        if (index == 1) {
            return this.getArgument2();
        }
        throw new IndexOutOfBoundsException("Illegal argument index: " + index + " for a " + DataPropertyAtom.class.getSimpleName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setArgument(int index, SWRLObject obj) {
        if (index > 1) {
            throw new IndexOutOfBoundsException("Illegal argument index: " + index + " for a " + DataPropertyAtom.class.getSimpleName());
        }
        if (index == 0) {
            if (!(obj instanceof SWRLIndividualObject)) throw new IllegalArgumentException("First argument of a " + DataPropertyAtom.class.getSimpleName() + " should be a " + SWRLIndividualObject.class.getSimpleName());
            this.setArgument1((SWRLIndividualObject)obj);
            return;
        } else {
            if (!(obj instanceof SWRLDataObject)) throw new IllegalArgumentException("Second argument of a " + DataPropertyAtom.class.getSimpleName() + " should be a " + SWRLDataObject.class.getSimpleName());
            this.setArgument2((SWRLDataObject)obj);
        }
    }

    @Override
    public void setArgument1(SWRLIndividualObject obj) {
        this.setProperty(SWRL.argument1, obj);
    }

    @Override
    public void setArgument2(SWRLDataObject obj) {
        if (obj.isDataValue()) {
            this.setProperty(SWRL._argument2, obj);
        } else {
            this.setProperty(SWRL.argument2, (SWRLDataVariable)obj);
        }
    }

    @Override
    public String toString() {
        return "(" + this.getArgument1() + " " + this.getPropertyPredicate().getQName() + " " + this.getArgument2() + ")";
    }

    @Override
    public void evaluate(ValueMap<?, ?> values) {
        SWRLIndividualObject subject = this.getArgument1();
        SWRLDataObject object = this.getArgument2();
        OWLIndividual subjectInd = this.getVariableIndividualValue(subject, values);
        OWLDataValue objectDV = this.getVariableDataValue(object, values);
        subjectInd = subjectInd != null ? subjectInd : subject;
        objectDV = objectDV != null ? objectDV : object;
        subjectInd.setProperty(this.getPropertyPredicate(), (Object)objectDV);
    }
}

