/*
 * Decompiled with CFR 0.152.
 */
package impl.swrl;

import impl.swrl.BuiltinAtomImpl;
import impl.swrl.ClassAtomImpl;
import impl.swrl.DataPropertyAtomImpl;
import impl.swrl.DifferentIndividualsAtomImpl;
import impl.swrl.IndividualPropertyAtomImpl;
import impl.swrl.SWRLConverters;
import impl.swrl.SWRLDataValueImpl;
import impl.swrl.SWRLDataVariableImpl;
import impl.swrl.SWRLIndividualImpl;
import impl.swrl.SWRLIndividualVariableImpl;
import impl.swrl.SameIndividualAtomImpl;
import java.net.URI;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLObjectConverterRegistry;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLDataValue;
import org.mindswap.swrl.SWRLDataVariable;
import org.mindswap.swrl.SWRLIndividual;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.SWRLIndividualVariable;
import org.mindswap.swrl.SWRLProvider;
import org.mindswap.swrl.SameIndividualAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLProviderImpl
implements SWRLProvider {
    private final OWLModel model;

    public SWRLProviderImpl() {
        this.model = null;
    }

    public SWRLProviderImpl(OWLModel model) {
        assert (model != null) : "Required OWLModel is null";
        this.model = model;
    }

    @Override
    public OWLList<Atom> createList() {
        return this.model.createList(SWRL.AtomListVocabulary);
    }

    @Override
    public OWLList<Atom> createList(Atom atom) {
        return this.model.createList(SWRL.AtomListVocabulary, atom);
    }

    @Override
    public SWRLIndividualVariable createIndividualVariable(URI uri) {
        return new SWRLIndividualVariableImpl(this.model.createInstance(SWRL.Variable, uri));
    }

    @Override
    public SWRLDataVariable createDataVariable(URI uri) {
        return new SWRLDataVariableImpl(this.model.createInstance(SWRL.Variable, uri));
    }

    @Override
    public ClassAtom createClassAtom(OWLClass c, OWLIndividual arg) {
        return this.createClassAtom(c, arg.castTo(SWRLIndividualObject.class));
    }

    @Override
    public ClassAtom createClassAtom(OWLClass c, SWRLIndividualObject arg) {
        ClassAtomImpl atom = new ClassAtomImpl(this.model.createInstance(SWRL.ClassAtom, null));
        atom.setClassPredicate(c);
        atom.setArgument1(arg);
        return atom;
    }

    @Override
    public IndividualPropertyAtom createIndividualPropertyAtom(OWLObjectProperty p, OWLIndividual arg1, OWLIndividual arg2) {
        return this.createIndividualPropertyAtom(p, arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLIndividualObject.class));
    }

    @Override
    public IndividualPropertyAtom createIndividualPropertyAtom(OWLObjectProperty p, SWRLIndividualObject arg1, SWRLIndividualObject arg2) {
        IndividualPropertyAtomImpl atom = new IndividualPropertyAtomImpl(this.model.createInstance(SWRL.IndividualPropertyAtom, null));
        atom.setPropertyPredicate(p);
        atom.setArgument1(arg1);
        atom.setArgument2(arg2);
        return atom;
    }

    @Override
    public DataPropertyAtom createDataPropertyAtom(OWLDataProperty p, OWLIndividual arg1, OWLValue arg2) {
        return this.createDataPropertyAtom(p, arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLDataObject.class));
    }

    @Override
    public DataPropertyAtom createDataPropertyAtom(OWLDataProperty p, SWRLIndividualObject arg1, SWRLDataObject arg2) {
        DataPropertyAtomImpl atom = new DataPropertyAtomImpl(this.model.createInstance(SWRL.DatavaluedPropertyAtom, null));
        atom.setPropertyPredicate(p);
        atom.setArgument1(arg1);
        atom.setArgument2(arg2);
        return atom;
    }

    @Override
    public SameIndividualAtom createSameIndividualAtom(OWLIndividual arg1, OWLIndividual arg2) {
        return this.createSameIndividualAtom(arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLIndividualObject.class));
    }

    @Override
    public SameIndividualAtom createSameIndividualAtom(SWRLIndividualObject arg1, SWRLIndividualObject arg2) {
        SameIndividualAtomImpl atom = new SameIndividualAtomImpl(this.model.createInstance(SWRL.SameIndividualAtom, null));
        atom.setArgument1(arg1);
        atom.setArgument2(arg2);
        return atom;
    }

    @Override
    public DifferentIndividualsAtom createDifferentIndividualsAtom(OWLIndividual arg1, OWLIndividual arg2) {
        return this.createDifferentIndividualsAtom(arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLIndividualObject.class));
    }

    @Override
    public DifferentIndividualsAtom createDifferentIndividualsAtom(SWRLIndividualObject arg1, SWRLIndividualObject arg2) {
        DifferentIndividualsAtomImpl atom = new DifferentIndividualsAtomImpl(this.model.createInstance(SWRL.DifferentIndividualsAtom, null));
        atom.setArgument1(arg1);
        atom.setArgument2(arg2);
        return atom;
    }

    @Override
    public BuiltinAtom createEqual(SWRLDataObject arg1, SWRLDataObject arg2) {
        return this.create(SWRLB.equal, arg1, arg2);
    }

    @Override
    public BuiltinAtom createNotEqual(SWRLDataObject arg1, SWRLDataObject arg2) {
        return this.create(SWRLB.notEqual, arg1, arg2);
    }

    @Override
    public BuiltinAtom createLessThan(SWRLDataObject arg1, SWRLDataObject arg2) {
        return this.create(SWRLB.lessThan, arg1, arg2);
    }

    @Override
    public BuiltinAtom createLessThanOrEqual(SWRLDataObject arg1, SWRLDataObject arg2) {
        return this.create(SWRLB.lessThanOrEqual, arg1, arg2);
    }

    @Override
    public BuiltinAtom createGreaterThan(SWRLDataObject arg1, SWRLDataObject arg2) {
        return this.create(SWRLB.greaterThan, arg1, arg2);
    }

    @Override
    public BuiltinAtom createGreaterThanOrEqual(SWRLDataObject arg1, SWRLDataObject arg2) {
        return this.create(SWRLB.greaterThanOrEqual, arg1, arg2);
    }

    @Override
    public BuiltinAtom createAdd(OWLValue result, OWLValue ... summands) {
        OWLValue[] args = new OWLValue[summands.length + 1];
        args[0] = result;
        System.arraycopy(summands, 0, args, 1, summands.length);
        return this.create(SWRLB.add, args);
    }

    @Override
    public BuiltinAtom createSubtract(OWLValue result, OWLValue minuend, OWLValue subtrahend) {
        return this.create(SWRLB.subtract, minuend, subtrahend);
    }

    @Override
    public BuiltinAtom createMultiply(OWLValue result, OWLValue ... factors) {
        OWLValue[] args = new OWLValue[factors.length + 1];
        args[0] = result;
        System.arraycopy(factors, 0, args, 1, factors.length);
        return this.create(SWRLB.multiply, args);
    }

    @Override
    public BuiltinAtom createDivide(OWLValue result, OWLValue arg1, OWLValue arg2) {
        return this.create(SWRLB.divide, result, arg1, arg2);
    }

    @Override
    public BuiltinAtom createMod(OWLValue result, OWLValue arg1, OWLValue arg2) {
        return this.create(SWRLB.mod, result, arg1, arg2);
    }

    @Override
    public BuiltinAtom createPow(OWLValue result, OWLValue arg1, OWLValue arg2) {
        return this.create(SWRLB.pow, result, arg1, arg2);
    }

    @Override
    public BuiltinAtom createBuiltinAtom(OWLIndividual builtin, OWLValue ... args) {
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("Invalid number of arguments (min 1).");
        }
        return this.create(builtin, args);
    }

    @Override
    public SWRLIndividual wrapIndividual(OWLIndividual ind) {
        return new SWRLIndividualImpl(ind);
    }

    @Override
    public SWRLDataValue wrapDataValue(OWLDataValue dv) {
        return new SWRLDataValueImpl(dv);
    }

    @Override
    public void registerConverters(OWLObjectConverterRegistry registry) {
        SWRLConverters.registerConverters(registry);
    }

    private BuiltinAtom create(OWLIndividual kind, OWLValue ... args) {
        BuiltinAtomImpl atom = new BuiltinAtomImpl(this.model.createInstance(SWRL.BuiltinAtom, null));
        atom.setBuiltin(kind);
        for (OWLValue value : args) {
            atom.addArgument(value.castTo(SWRLDataObject.class));
        }
        return atom;
    }
}

