/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFinder {
    private static final Logger logger = LoggerFactory.getLogger(ServiceFinder.class);
    private static final ServiceFinder instance = new ServiceFinder();
    private final Map<Class<?>, Class<?>> implCache = new HashMap();

    private ServiceFinder() {
    }

    public static final ServiceFinder instance() {
        return instance;
    }

    public final <I> I createInstance(Class<I> interfaze, String deflt, Object ... args) {
        Class<Object> implClass = this.implCache.get(interfaze);
        if (implClass == null) {
            List<Class<I>> implementations = this.findImplementations(interfaze, deflt, true);
            if (implementations.isEmpty()) {
                return null;
            }
            implClass = implementations.get(0);
            this.implCache.put(interfaze, implClass);
        }
        return (I)this.instantiate(implClass, args);
    }

    public final <I> List<I> loadImplementations(Class<I> interfaze, Object ... args) {
        return this.findImpls(interfaze, args);
    }

    public final <I> I loadImplementation(Class<I> interfaze, String deflt, Object ... args) {
        return this.findImpl(interfaze, deflt, args);
    }

    private final <I> I instantiate(Class<? extends I> impl, Object ... args) {
        try {
            Constructor<?>[] cs;
            if (args == null || args.length == 0) {
                return impl.newInstance();
            }
            block2: for (Constructor<?> c : cs = impl.getConstructors()) {
                Class<?>[] paramTypes = c.getParameterTypes();
                if (paramTypes.length != args.length) continue;
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (!paramTypes[i].isAssignableFrom(args[i].getClass())) continue block2;
                }
                return (I)c.newInstance(args);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to instantiate {}. Details: {}", impl, (Object)e.toString());
        }
        return null;
    }

    private final <I> I findImpl(Class<I> interfaze, String deflt, Object ... args) {
        List<Class<I>> implementations = this.findImplementations(interfaze, deflt, true);
        if (implementations.isEmpty()) {
            return null;
        }
        Class<I> implClass = implementations.get(0);
        I implInstance = this.instantiate(implClass, args);
        if (implementations.size() > 1) {
            logger.info("More than one implementation of {} found. Using the first one found {}", interfaze, implClass);
        } else {
            logger.debug("Using {} implementation of {}", implClass, interfaze);
        }
        return implInstance;
    }

    private final <I> List<I> findImpls(Class<I> interfaze, Object ... args) {
        List<Class<I>> implClasses = this.findImplementations(interfaze, null, false);
        ArrayList<I> implInstances = new ArrayList<I>(implClasses.size());
        for (Class<I> implClass : implClasses) {
            I implInstance = this.instantiate(implClass, args);
            if (implInstance == null) continue;
            implInstances.add(implInstance);
        }
        return implInstances;
    }

    private final <I> List<Class<? extends I>> findImplementations(Class<I> interfaze, String deflt, boolean considerSystemProperty) {
        Class<I> provider;
        ClassLoader loader = ServiceFinder.class.getClassLoader();
        ArrayList<Class<I>> providers = new ArrayList<Class<I>>();
        if (considerSystemProperty && (provider = this.checkSystemProperty(interfaze)) != null) {
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            try {
                Enumeration<URL> providerLists = loader.getResources("META-INF/services/" + interfaze.getName());
                while (providerLists.hasMoreElements()) {
                    URL providerList = providerLists.nextElement();
                    providers.addAll(this.findInFile(providerList, interfaze));
                }
            }
            catch (IOException ex) {
                logger.error("Failed to locate service provider meta file(s) for {}.", interfaze, (Object)ex);
            }
        }
        if (providers.isEmpty() && deflt != null) {
            try {
                Class<I> defImpl = Class.forName(deflt).asSubclass(interfaze);
                providers.add(defImpl);
            }
            catch (Exception e) {
                logger.debug("Faile to load default implementation for {}. Details: {}", interfaze, (Object)e.toString());
            }
        }
        if (providers.size() == 0) {
            logger.debug("No implementations of {} found; neither via so named system property, classpath, and default.", interfaze);
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <I> List<Class<? extends I>> findInFile(URL implFile, Class<I> interfaze) {
        BufferedReader reader = null;
        ArrayList<Class<I>> implementations = new ArrayList<Class<I>>();
        try {
            String implClassName;
            reader = new BufferedReader(new InputStreamReader(implFile.openStream()));
            while ((implClassName = reader.readLine()) != null) {
                int comment = implClassName.indexOf(35);
                if (comment != -1) {
                    implClassName = implClassName.substring(0, comment);
                }
                if ((implClassName = implClassName.trim()).length() <= 0) continue;
                try {
                    Class<I> implClass = Class.forName(implClassName).asSubclass(interfaze);
                    implementations.add(implClass);
                }
                catch (Exception e) {
                    logger.debug("Failed to load " + implClassName, (Throwable)e);
                }
            }
        }
        catch (IOException ex) {
            logger.error("Failed to read service provider file {}", (Object)implFile, (Object)ex);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return implementations;
    }

    private final <I> Class<? extends I> checkSystemProperty(Class<I> interfaze) {
        String prop = System.getProperty(interfaze.getName());
        if (prop == null) {
            return null;
        }
        logger.debug("Found system property {}, value={}", (Object)interfaze.getName(), (Object)prop);
        try {
            return Class.forName(prop).asSubclass(interfaze);
        }
        catch (Exception e) {
            logger.debug("Class {} could not be loaded. Details {}", (Object)prop, (Object)e.toString());
            return null;
        }
    }
}

