/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl;

import impl.owl.CombinedOWLConverter;
import impl.owl.ListConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mindswap.common.ServiceFinder;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLObjectConverterProvider;
import org.mindswap.owl.OWLProvider;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.ListVocabulary;
import org.mindswap.owls.OWLSProvider;
import org.mindswap.owls.grounding.JavaGroundingProvider;
import org.mindswap.owls.grounding.UPnPGroundingProvider;
import org.mindswap.owls.grounding.WSDLGroundingProvider;
import org.mindswap.swrl.SWRLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectConverterRegistry {
    private static final Logger logger = LoggerFactory.getLogger(OWLObjectConverterRegistry.class);
    private static final OWLObjectConverterRegistry instance = new OWLObjectConverterRegistry();
    private final ConverterMap converters = new ConverterMap();
    private final ListConverterMap listConverters = new ListConverterMap();

    private OWLObjectConverterRegistry() {
        OWLProvider owlProvider = ServiceFinder.instance().loadImplementation(OWLProvider.class, "impl.jena.JenaOWLProvider", new Object[0]);
        OWLSProvider owlsProvider = ServiceFinder.instance().loadImplementation(OWLSProvider.class, "impl.owls.OWLSProviderImpl", new Object[0]);
        JavaGroundingProvider javaGdgProvider = ServiceFinder.instance().loadImplementation(JavaGroundingProvider.class, "impl.owls.grounding.JavaGroundingProviderImpl", new Object[0]);
        WSDLGroundingProvider wsdlGdgProvider = ServiceFinder.instance().loadImplementation(WSDLGroundingProvider.class, "impl.owls.grounding.WSDLGroundingProviderImpl", new Object[0]);
        UPnPGroundingProvider upnpGdgProvider = ServiceFinder.instance().loadImplementation(UPnPGroundingProvider.class, "impl.owls.grounding.UPnPGroundingProviderImpl", new Object[0]);
        SWRLProvider swrlProvider = ServiceFinder.instance().loadImplementation(SWRLProvider.class, "impl.swrl.SWRLProviderImpl", new Object[0]);
        if (owlProvider != null) {
            owlProvider.registerConverters(this);
        } else {
            this.logNoImplFound(OWLProvider.class);
        }
        if (owlsProvider != null) {
            owlsProvider.registerConverters(this);
        } else {
            this.logNoImplFound(OWLSProvider.class);
        }
        if (wsdlGdgProvider != null) {
            wsdlGdgProvider.registerConverters(this);
        } else {
            this.logNoImplFound(WSDLGroundingProvider.class);
        }
        if (javaGdgProvider != null) {
            javaGdgProvider.registerConverters(this);
        } else {
            this.logNoImplFound(JavaGroundingProvider.class);
        }
        if (upnpGdgProvider != null) {
            upnpGdgProvider.registerConverters(this);
        } else {
            this.logNoImplFound(UPnPGroundingProvider.class);
        }
        if (swrlProvider != null) {
            swrlProvider.registerConverters(this);
        } else {
            this.logNoImplFound(SWRLProvider.class);
        }
        List<OWLObjectConverterProvider> providers = ServiceFinder.instance().loadImplementations(OWLObjectConverterProvider.class, new Object[0]);
        for (OWLObjectConverterProvider provider : providers) {
            provider.registerConverters(this);
        }
    }

    public static final OWLObjectConverterRegistry instance() {
        return instance;
    }

    public <T extends OWLObject> void extendByConverter(Class<T> target, OWLObjectConverter<? extends T> converter) {
        ArrayList cs = new ArrayList(3);
        cs.add(converter);
        CombinedOWLConverter<? extends T> c = this.converters.putIfAbsent(target, new CombinedOWLConverter(target, cs));
        if (c == null) {
            return;
        }
        if (c instanceof CombinedOWLConverter) {
            CombinedOWLConverter<? extends T> cc = c;
            cc.addConverter(converter);
        } else {
            cs.add(c);
            this.converters.put(target, new CombinedOWLConverter(target, cs));
        }
    }

    public <T extends OWLObject> OWLObjectConverter<T> getConverter(Class<T> target) {
        return this.converters.get(target);
    }

    public <T extends OWLValue> ListConverter<T> getListConverter(ListVocabulary<T> target) {
        return this.listConverters.get(target);
    }

    public <T extends OWLObject> OWLObjectConverter<T> registerConverter(Class<T> target, OWLObjectConverter<T> converter) {
        OWLObjectConverter<T> old = this.converters.put(target, converter);
        if (old != null) {
            logger.info("OWL object converter for {} already registered. Existing converter {} was overridden by {}", new Object[]{target.getName(), old, converter});
        }
        return old;
    }

    public <T extends OWLValue> ListConverter<T> registerListConverter(ListVocabulary<T> vocabulary, ListConverter<T> converter) {
        ListConverter<T> old = this.listConverters.put(vocabulary, converter);
        if (old != null) {
            logger.info("OWL list converter for {} already registered. Existing converter {} was overridden by {}", new Object[]{vocabulary, old, converter});
        }
        return old;
    }

    private void logNoImplFound(Class<?> interfaze) {
        logger.error("No implementation found for {}", interfaze);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListConverterMap {
        final Map<ListVocabulary<? extends OWLValue>, ListConverter<? extends OWLValue>> map = new ConcurrentHashMap<ListVocabulary<? extends OWLValue>, ListConverter<? extends OWLValue>>(10);

        ListConverterMap() {
        }

        <T extends OWLValue> ListConverter<T> put(ListVocabulary<T> target, ListConverter<T> converter) {
            return this.map.put(target, converter);
        }

        <T extends OWLValue> ListConverter<T> get(ListVocabulary<T> target) {
            return this.map.get(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConverterMap {
        final ConcurrentHashMap<Class<? extends OWLObject>, OWLObjectConverter<? extends OWLObject>> map = new ConcurrentHashMap(60);

        ConverterMap() {
        }

        <C extends OWLObjectConverter<T>, T extends OWLObject> C put(Class<T> target, C converter) {
            return (C)this.map.put(target, converter);
        }

        <C extends OWLObjectConverter<T>, T extends OWLObject> C putIfAbsent(Class<T> target, C converter) {
            return (C)this.map.putIfAbsent(target, converter);
        }

        <C extends OWLObjectConverter<T>, T extends OWLObject> C get(Class<T> target) {
            return (C)this.map.get(target);
        }
    }
}

