/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl.vocabulary;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Vocabulary {
    private static final Logger logger = LoggerFactory.getLogger(Vocabulary.class);
    private static final OWLKnowledgeBase kb = OWLFactory.createKB();

    protected static String addAlternativeLocation(String original, String copy) {
        URI origURI = URIUtils.standardURI(original);
        URI altnURI = URIUtils.standardURI(copy);
        return kb.getManager().setAlternativeLocation(origURI, altnURI).toString();
    }

    protected static OWLOntology getOntology(URI ontologyURI) {
        return kb.getOntology(ontologyURI);
    }

    protected static OWLOntology loadOntology(String ontologyURL) {
        return Vocabulary.loadOntology(ontologyURL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OWLOntology loadOntology(String ontologyURL, String local) {
        logger.info("Loading ontology {} ...", (Object)ontologyURL);
        URI uri = URIUtils.standardURI(ontologyURL);
        try {
            OWLOntology loadedOnt = kb.read(uri);
            loadedOnt.setReadOnly(true);
            return loadedOnt;
        }
        catch (IOException ioe) {
            String details = ioe.toString();
            if (local != null) {
                InputStream in = ClassLoader.getSystemResourceAsStream(local);
                try {
                    OWLOntology loadedOnt = kb.read(in, uri);
                    loadedOnt.setReadOnly(true);
                    OWLOntology oWLOntology = loadedOnt;
                    return oWLOntology;
                }
                catch (IOException iioe) {
                    details = details + ", " + iioe.toString();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
            throw new RuntimeException("Fatal: Failed to load OWL ontology file " + ontologyURL + "! Details: " + details);
        }
    }
}

