/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.io.ExpressionWriter;
import org.mindswap.utils.QNameProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExpressionWriter<B>
implements ExpressionWriter<B> {
    protected QNameProvider qnames;
    protected PrintWriter out;
    protected String indent;
    protected boolean firstLineIndent = false;

    @Override
    public void setWriter(Writer out) {
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    @Override
    public PrintWriter getWriter() {
        return this.out;
    }

    @Override
    public void setWriter(OutputStream out) {
        this.out = new PrintWriter(out);
    }

    @Override
    public String getIndent() {
        return this.indent;
    }

    @Override
    public void setIndent(String indent) {
        this.indent = indent;
    }

    @Override
    public boolean getFirstLineIndent() {
        return this.firstLineIndent;
    }

    @Override
    public void setFirstLineIndent(boolean indent) {
        this.firstLineIndent = indent;
    }

    @Override
    public void setQNames(QNameProvider qnames) {
        this.qnames = qnames;
    }

    @Override
    public QNameProvider getQNames() {
        return this.qnames;
    }

    @Override
    public void write(Expression<B> expr, Writer outWriter) {
        boolean noQNameProvider;
        this.setWriter(outWriter);
        boolean bl = noQNameProvider = this.qnames == null;
        if (noQNameProvider) {
            this.qnames = expr.getKB().getQNames();
        }
        this.write(expr.getBody());
        if (noQNameProvider) {
            this.qnames = null;
        }
    }

    @Override
    public void write(Expression<B> expr, OutputStream outStream) {
        this.setWriter(outStream);
        this.write((B)expr);
    }

    @Override
    public void write(Expression<B> expr) {
        this.write(expr.getBody());
    }

    protected abstract void write(B var1);

    protected void print(OWLValue value) {
        try {
            if (value instanceof OWLIndividual) {
                OWLIndividual ind = (OWLIndividual)value;
                if (ind.isAnon()) {
                    this.out.print("<< Anonymous Individual >>");
                } else {
                    this.print(ind.getURI());
                }
            } else {
                this.out.print(value);
            }
        }
        catch (RuntimeException e) {
            this.out.print("<< Invalid URI >>");
        }
    }

    protected void print(OWLClass cls) {
        if (cls.isAnon()) {
            this.out.print("<< Anonymous Class >>");
        } else {
            this.print(cls.getURI());
        }
    }

    protected void print(OWLProperty prop) {
        this.print(prop.getURI());
    }

    protected void print(URI uri) {
        this.out.print(this.qnames.shortForm(uri));
    }
}

