/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.mindswap.exceptions.InvalidURIException;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.vocabulary.XSD;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.io.ExpressionWriter;
import org.mindswap.owls.io.ProcessWriter;
import org.mindswap.owls.io.SparqlExpressionWriter;
import org.mindswap.owls.io.SwrlExpressionWriter;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AsProcess;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructVisitor;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Set;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.InputBinding;
import org.mindswap.owls.process.variable.Local;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.OutputBinding;
import org.mindswap.owls.process.variable.Parameter;
import org.mindswap.owls.process.variable.ParameterValue;
import org.mindswap.owls.process.variable.ParameterValueVisitor;
import org.mindswap.owls.process.variable.ResultVar;
import org.mindswap.owls.process.variable.ValueConstant;
import org.mindswap.owls.process.variable.ValueForm;
import org.mindswap.owls.process.variable.ValueFunction;
import org.mindswap.owls.process.variable.ValueOf;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.utils.QNameProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationSyntaxWriter
implements ProcessWriter {
    private static final String INDENT = "   ";
    private String indent = "";
    private QNameProvider qnames = new QNameProvider();
    PrintWriter out;
    private Writer writer;
    private SwrlExpressionWriter swrlExprWriter;
    private SparqlExpressionWriter sparqlExprWriter;
    private String defaultNS;

    public String getDefaultNS() {
        return this.defaultNS;
    }

    public void setDefaultNS(String defaultNS) {
        this.defaultNS = defaultNS.endsWith("#") ? defaultNS : defaultNS + "#";
    }

    @Override
    public ExpressionWriter<String> getSparqlExpressionWriter() {
        if (this.sparqlExprWriter == null) {
            this.sparqlExprWriter = new SparqlExpressionWriter();
        }
        return this.sparqlExprWriter;
    }

    public SwrlExpressionWriter getSwrlExpressionWriter() {
        if (this.swrlExprWriter == null) {
            this.swrlExprWriter = new SwrlExpressionWriter();
        }
        return this.swrlExprWriter;
    }

    String qname(OWLEntity entity) {
        if (entity.isAnon()) {
            return "<< Anonymous " + (entity instanceof OWLClass ? "Class" : "Individual") + " >>";
        }
        return this.qnames.shortForm(entity.getURI());
    }

    String qname(URI uri) {
        try {
            return this.qnames.shortForm(uri);
        }
        catch (Exception e) {
            return "<< Invalid URI >>";
        }
    }

    private void indent(boolean left) {
        this.indent = left ? this.indent + INDENT : this.indent.substring(INDENT.length());
    }

    private void printIndented() {
        this.out.print(this.indent);
    }

    private void printIndented(String str) {
        this.printIndented();
        this.out.print(str);
    }

    private void printlnIndented(String str) {
        this.printIndented();
        this.out.println(str);
    }

    private String repeat(char c, int n) {
        char[] chars = new char[n];
        Arrays.fill(chars, c);
        return String.copyValueOf(chars);
    }

    void block(boolean start) {
        if (start) {
            this.printlnIndented("{");
            this.indent(true);
        } else {
            this.indent(false);
            this.printIndented("}");
        }
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setWriter(OutputStream stream) {
        this.setWriter(new OutputStreamWriter(stream));
    }

    @Override
    public void write(Process process, OutputStream stream) {
        this.setWriter(stream);
        this.write(process);
    }

    @Override
    public void write(Process process, Writer outWriter) {
        this.setWriter(outWriter);
        this.write(process);
    }

    @Override
    public void write(Process process) {
        this.write(Collections.singleton(process));
    }

    @Override
    public void write(Collection<Process> processes) {
        if (this.defaultNS != null) {
            this.qnames.setMapping("", this.defaultNS);
        }
        StringWriter buffer = new StringWriter();
        this.out = new PrintWriter(buffer);
        this.swrlExprWriter.setWriter(this.out);
        this.swrlExprWriter.setIndent("");
        this.swrlExprWriter.setQNames(this.qnames);
        this.indent(true);
        for (Process process : processes) {
            this.writeProcess(process);
        }
        this.indent(false);
        this.out.flush();
        this.out = new PrintWriter(this.writer);
        this.writeHeader();
        this.out.println(buffer.toString());
        this.writeFooter();
        this.out.flush();
    }

    private void writeHeader() {
        this.out.println("with_namespaces");
        HashSet<String> prefixSet = new HashSet<String>(this.qnames.getPrefixSet());
        String defNS = this.qnames.getURI("");
        if (defNS != null) {
            this.out.println("  (uri\"" + defNS + "\",");
            prefixSet.remove("");
        }
        Iterator i = prefixSet.iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = this.qnames.getURI(prefix);
            this.out.print(INDENT + prefix + ":  \"" + uri + "\"");
            if (i.hasNext()) {
                this.out.println(",");
                continue;
            }
            this.out.println(")");
        }
        this.out.println("{");
        this.out.println();
    }

    private void writeFooter() {
        this.out.println("}");
    }

    private boolean emptyProcess(Process process) {
        return process.getInputs().isEmpty() && (!(process instanceof CompositeProcess) || ((CompositeProcess)process).getLocals().isEmpty()) && process.getOutputs().isEmpty() && process.getConditions().isEmpty() && process.getResults().isEmpty();
    }

    private void writeProcess(Process process) {
        if (process instanceof AtomicProcess) {
            this.writeProcess((AtomicProcess)process);
        } else if (process instanceof CompositeProcess) {
            this.writeProcess((CompositeProcess)process);
        } else {
            throw new NotImplementedException("Only writing Atomic and Composite process implemented yet");
        }
        this.out.println();
    }

    private void writeProcess(CompositeProcess process) {
        this.printIndented("define composite process ");
        this.out.print(process.getLocalName() + "(");
        if (!this.emptyProcess(process)) {
            this.out.println();
            this.writeIO(process);
            this.writePreconditions(process);
            this.writeResults(process);
        }
        this.out.println(")");
        ControlConstruct cc = process.getComposedOf();
        if (cc != null) {
            this.writeConstruct(cc, true);
        }
        this.out.println();
    }

    private void writeIO(Process process) {
        OWLIndividualList<Output> outputs;
        OWLType type;
        OWLIndividualList<Local> locals;
        this.indent(true);
        OWLIndividualList<Input> inputs = process.getInputs();
        if (inputs.size() > 0) {
            this.printIndented("inputs: (");
            for (int i = 0; i < inputs.size(); ++i) {
                Input input = (Input)inputs.get(i);
                OWLType type2 = input.getParamType();
                this.out.print(this.qname(input));
                this.out.print(" - " + this.qname(type2.getURI()));
                if (i < inputs.size() - 1) {
                    this.out.println();
                    this.printIndented("         ");
                    continue;
                }
                this.out.print(")");
            }
        }
        if (process instanceof CompositeProcess && (locals = ((CompositeProcess)process).getLocals()).size() > 0) {
            this.out.println(",");
            this.printIndented("locals: (");
            for (int i = 0; i < locals.size(); ++i) {
                Local local = (Local)locals.get(i);
                type = local.getParamType();
                this.out.print(this.qname(local));
                this.out.print(" - " + this.qname(type.getURI()));
                if (i < locals.size() - 1) {
                    this.out.println();
                    this.printIndented("         ");
                    continue;
                }
                this.out.print(")");
            }
        }
        if ((outputs = process.getOutputs()).size() > 0) {
            this.out.println(",");
            this.printIndented("outputs: (");
            for (int i = 0; i < outputs.size(); ++i) {
                Output output = (Output)outputs.get(i);
                type = output.getParamType();
                this.out.print(this.qname(output));
                this.out.print(" - " + this.qname(type.getURI()));
                if (i < outputs.size() - 1) {
                    this.out.println();
                    this.printIndented("          ");
                    continue;
                }
                this.out.print(")");
            }
        }
        this.indent(false);
    }

    void writePerform(Perform perform) {
        Process process = perform.getProcess();
        String str = this.qname(perform) + " :: perform " + this.qname(process) + "(";
        this.printIndented(str);
        OWLIndividualList<InputBinding> bindings = perform.getBindings();
        this.writeBindings(bindings, str.length());
        this.out.print(")");
    }

    private void writeBindings(OWLIndividualList<? extends Binding<?>> bindings, int extraIndent) {
        String pad = this.repeat(' ', extraIndent);
        for (int i = 0; i < bindings.size(); ++i) {
            Binding binding = (Binding)bindings.get(i);
            Object param = binding.getProcessVar();
            ParameterValue paramValue = binding.getValue();
            final StringBuilder mappedValue = new StringBuilder();
            paramValue.accept(new ParameterValueVisitor(){

                @Override
                public void visit(ValueOf valueOf) {
                    Perform otherPerform = valueOf.getPerform();
                    Parameter otherParam = valueOf.getParameter();
                    if (!otherPerform.equals(OWLS_1_2.Process.ThisPerform)) {
                        mappedValue.append(PresentationSyntaxWriter.this.qname(otherPerform)).append(".");
                    }
                    mappedValue.append(PresentationSyntaxWriter.this.qname(otherParam));
                }

                @Override
                public void visit(ValueFunction<?> valueFunction) {
                    mappedValue.append(valueFunction.getFunction());
                }

                @Override
                public void visit(ValueForm vf) {
                    mappedValue.append("<< ValueForm no yet supported >>");
                }

                @Override
                public void visit(ValueConstant valueData) {
                    if (valueData.isDataValue()) {
                        boolean quote;
                        OWLDataValue value = valueData.getData();
                        URI datatypeURI = value.getDatatypeURI();
                        boolean bl = quote = datatypeURI == null || !datatypeURI.equals(XSD.xsdBoolean) && !datatypeURI.equals(XSD.integer) && !datatypeURI.equals(XSD.xsdInt) && !datatypeURI.equals(XSD.decimal) && !datatypeURI.equals(XSD.xsdDouble);
                        if (quote) {
                            mappedValue.append("\"").append(value).append("\"");
                            if (datatypeURI != null) {
                                mappedValue.append("^^").append(PresentationSyntaxWriter.this.qname(datatypeURI));
                            }
                        } else {
                            mappedValue.append(value);
                        }
                    } else {
                        mappedValue.append(PresentationSyntaxWriter.this.qname(valueData.getIndividual()));
                    }
                }
            });
            this.out.print(this.qname((OWLEntity)param) + " <= " + mappedValue);
            if (i >= bindings.size() - 1) continue;
            this.out.print(", ");
            if (bindings.size() <= 1) continue;
            this.out.println();
            this.printIndented();
            this.out.print(pad);
        }
    }

    private void writeConstruct(final ControlConstruct cc, final boolean block) {
        cc.accept(new ControlConstructVisitor(){

            public void visit(SplitJoin sj) {
                PresentationSyntaxWriter.this.writeComponents(sj.getConstructs(), "||>");
            }

            public void visit(Split st) {
                PresentationSyntaxWriter.this.writeComponents(st.getConstructs(), "||<");
            }

            public void visit(Set set) {
                PresentationSyntaxWriter.this.out.println("<< Not yet implemented " + cc.getConstructName() + " >>");
            }

            public void visit(Sequence sq) {
                PresentationSyntaxWriter.this.writeComponents(sq.getConstructs(), ";");
            }

            public void visit(RepeatWhile rw) {
                PresentationSyntaxWriter.this.out.println("<< Not yet implemented " + cc.getConstructName() + " >>");
            }

            public void visit(RepeatUntil ru) {
                PresentationSyntaxWriter.this.out.println("<< Not yet implemented " + cc.getConstructName() + " >>");
            }

            public void visit(Produce pr) {
                if (block) {
                    PresentationSyntaxWriter.this.block(true);
                }
                PresentationSyntaxWriter.this.writeProduce(pr);
                if (block) {
                    PresentationSyntaxWriter.this.out.println();
                    PresentationSyntaxWriter.this.block(false);
                }
            }

            public void visit(Perform pf) {
                if (block) {
                    PresentationSyntaxWriter.this.block(true);
                }
                PresentationSyntaxWriter.this.writePerform(pf);
                if (block) {
                    PresentationSyntaxWriter.this.out.println();
                    PresentationSyntaxWriter.this.block(false);
                }
            }

            public void visit(IfThenElse ite) {
                if (block) {
                    PresentationSyntaxWriter.this.block(true);
                }
                PresentationSyntaxWriter.this.writeIfThenElse(ite);
                if (block) {
                    PresentationSyntaxWriter.this.out.println();
                    PresentationSyntaxWriter.this.block(false);
                }
            }

            public void visit(ForEach fe) {
                PresentationSyntaxWriter.this.out.println("<< Not yet implemented " + cc.getConstructName() + " >>");
            }

            public void visit(Choice ch) {
                PresentationSyntaxWriter.this.writeComponents(ch.getConstructs(), ";?");
            }

            public void visit(AsProcess ap) {
                PresentationSyntaxWriter.this.out.println("<< Not yet implemented " + cc.getConstructName() + " >>");
            }

            public void visit(AnyOrder ao) {
                PresentationSyntaxWriter.this.writeComponents(ao.getConstructs(), "||;");
            }
        });
    }

    void writeComponents(OWLIndividualList<? extends ControlConstruct> components, String delim) {
        this.block(true);
        Iterator i = components.iterator();
        while (i.hasNext()) {
            ControlConstruct cc = (ControlConstruct)i.next();
            this.writeConstruct(cc, false);
            if (i.hasNext()) {
                this.out.println(delim);
                continue;
            }
            this.out.println();
        }
        this.block(false);
    }

    void writeIfThenElse(IfThenElse ifThenElse) {
        Condition<?> condition = ifThenElse.getCondition();
        ControlConstruct thenP = ifThenElse.getThen();
        ControlConstruct elseP = ifThenElse.getElse();
        this.printIndented("if( ");
        condition.writeTo(this, this.indent + "    ");
        this.out.println(" )");
        this.printlnIndented("then");
        this.writeConstruct(thenP, true);
        if (elseP != null) {
            this.out.println();
            this.printlnIndented("else");
            this.writeConstruct(elseP, true);
        }
    }

    void writeProduce(Produce produce) {
        OWLIndividualList<OutputBinding> bindings = produce.getOutputBindings();
        if (!bindings.isEmpty()) {
            String str = "produce(";
            this.printIndented("produce(");
            this.writeBindings(bindings, "produce(".length());
            this.out.print(")");
        }
    }

    private void writeProcess(AtomicProcess process) {
        this.printIndented("define atomic process " + process.getLocalName() + "(");
        if (!this.emptyProcess(process)) {
            this.out.println();
            this.writeIO(process);
            this.writePreconditions(process);
            this.writeResults(process);
        }
        this.out.println(")");
    }

    private void writePreconditions(Process process) {
        this.indent(true);
        for (Condition condition : process.getConditions()) {
            this.out.println(",");
            this.printIndented("precondition: (");
            condition.writeTo(this, this.indent + "               ");
            this.out.print(")");
        }
        this.indent(false);
    }

    private void writeResults(Process process) {
        this.indent(true);
        for (Result result : process.getResults()) {
            Expression<?> effect;
            this.out.println(",");
            this.printIndented("result: (");
            OWLIndividualList<ResultVar> resultVars = result.getResultVars();
            if (!resultVars.isEmpty()) {
                this.out.print("forall (");
                for (int i = 0; i < resultVars.size(); ++i) {
                    ResultVar resultVar = (ResultVar)resultVars.get(i);
                    OWLType type = resultVar.getParamType();
                    this.out.print(this.qname(resultVar));
                    this.out.print(" - " + this.qname(type.getURI()));
                    if (i < resultVars.size() - 1) {
                        this.out.println();
                        this.printIndented("                 ");
                        continue;
                    }
                    this.out.println(")");
                }
                this.printIndented("         ");
            }
            for (Condition condition : result.getConditions()) {
                if (condition.equals(OWLS_1_2.Expression.AlwaysTrue)) continue;
                condition.writeTo(this, "               ");
                this.out.println();
                this.printlnIndented("         |->");
                this.printIndented("         ");
            }
            OWLIndividualList<OutputBinding> bindings = result.getBindings();
            if (!bindings.isEmpty()) {
                this.out.print("output(");
                int pad = "result: (".length() + "output(".length();
                this.writeBindings(bindings, pad);
                this.out.print(")");
            }
            if ((effect = result.getEffect()) != null) {
                if (!bindings.isEmpty()) {
                    this.out.println(" & ");
                    this.printIndented("         ");
                }
                effect.writeTo(this, "               ");
            }
            this.out.print(")");
        }
        this.indent(false);
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void write(Collection<Process> processes, Writer outWriter) {
        this.setWriter(outWriter);
        this.write(processes);
    }

    @Override
    public void write(Collection<Process> processes, OutputStream outStream) {
        this.setWriter(outStream);
        this.write(processes);
    }

    @Override
    public QNameProvider getQNames() {
        return this.qnames;
    }

    @Override
    public void setQNames(QNameProvider qnames) {
        this.qnames = qnames;
    }

    public static void main(String[] args) throws InvalidURIException, IOException, URISyntaxException {
        if (args.length == 0) {
            System.out.println("No URL given!");
            System.out.println("Usage: " + PresentationSyntaxWriter.class.getName() + " <URL>");
            return;
        }
        URI uri = new URI(args[0]);
        PresentationSyntaxWriter writer = new PresentationSyntaxWriter();
        writer.setDefaultNS(uri.toString());
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setStrictConversion(false);
        kb.read(uri);
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll(kb.getProcesses(1, true));
        processes.addAll(kb.getProcesses(2, true));
        if (processes.isEmpty()) {
            System.err.println("No processes found in " + uri);
        } else {
            writer.write(processes, (OutputStream)System.out);
        }
    }
}

