/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.owls.io.BaseExpressionWriter;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomVisitor;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SameIndividualAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SwrlExpressionWriter
extends BaseExpressionWriter<OWLList<Atom>>
implements AtomVisitor {
    static final Map<OWLIndividual, String[]> SYMBOLS = new HashMap<OWLIndividual, String[]>();

    SwrlExpressionWriter() {
    }

    @Override
    protected void write(OWLList<Atom> atoms) {
        if (atoms == null || atoms.isEmpty()) {
            this.out.print("<Empty-Expression>");
            return;
        }
        boolean first = true;
        Iterator it = atoms.iterator();
        while (it.hasNext()) {
            if (!first || this.firstLineIndent) {
                this.out.print(this.indent);
            } else {
                first = false;
            }
            ((Atom)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.out.println(" &");
        }
    }

    @Override
    public void visit(BuiltinAtom atom) {
        OWLIndividual builtin = atom.getBuiltin();
        int count = atom.getArgumentCount();
        String[] symbols = SYMBOLS.get(builtin);
        if (symbols != null) {
            int extra = 0;
            if (symbols.length == count) {
                this.out.print(symbols[0]);
                extra = 1;
            }
            this.out.print("(");
            for (int i = 0; i < count; ++i) {
                this.out.print(atom.getArgument(i));
                if (i >= count - 1) continue;
                this.out.print(" " + symbols[i + extra] + " ");
            }
            this.out.print(")");
        } else {
            this.print(builtin);
            this.out.print("(");
            for (int i = 0; i < atom.getArgumentCount(); ++i) {
                if (i > 0) {
                    this.out.print(", ");
                }
                this.print(atom.getArgument(i));
            }
            this.out.print(")");
        }
    }

    @Override
    public void visit(ClassAtom atom) {
        this.print(atom.getClassPredicate());
        this.out.print("(");
        this.print(atom.getArgument1());
        this.out.print(")");
    }

    @Override
    public void visit(DataPropertyAtom atom) {
        this.print(atom.getPropertyPredicate());
        this.out.print("(");
        this.print(atom.getArgument1());
        this.out.print(", ");
        this.print(atom.getArgument2());
        this.out.print(")");
    }

    @Override
    public void visit(DifferentIndividualsAtom atom) {
        this.out.print("~(");
        this.print(atom.getArgument1());
        this.out.print(" = ");
        this.print(atom.getArgument2());
        this.out.print(")");
    }

    @Override
    public void visit(IndividualPropertyAtom atom) {
        this.print(atom.getPropertyPredicate());
        this.out.print("(");
        this.print(atom.getArgument1());
        this.out.print(", ");
        this.print(atom.getArgument2());
        this.out.print(")");
    }

    @Override
    public void visit(SameIndividualAtom atom) {
        this.out.print("(");
        this.print(atom.getArgument1());
        this.out.print(" = ");
        this.print(atom.getArgument2());
        this.out.print(")");
    }

    static {
        SYMBOLS.put(SWRLB.add, new String[]{"=", "+"});
        SYMBOLS.put(SWRLB.subtract, new String[]{"=", "-"});
        SYMBOLS.put(SWRLB.divide, new String[]{"=", "/"});
        SYMBOLS.put(SWRLB.multiply, new String[]{"=", "*"});
        SYMBOLS.put(SWRLB.mod, new String[]{"=", "%"});
        SYMBOLS.put(SWRLB.pow, new String[]{"=", "^"});
        SYMBOLS.put(SWRLB.lessThan, new String[]{"<"});
        SYMBOLS.put(SWRLB.lessThanOrEqual, new String[]{"<="});
        SYMBOLS.put(SWRLB.greaterThan, new String[]{">"});
        SYMBOLS.put(SWRLB.greaterThanOrEqual, new String[]{">="});
        SYMBOLS.put(SWRLB.equal, new String[]{"="});
        SYMBOLS.put(SWRLB.notEqual, new String[]{"~", "="});
    }
}

