/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.execution;

import java.util.Map;
import org.mindswap.common.Variable;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.execution.ExecutionContext;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Local;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.query.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseExecutionContext
implements ExecutionContext {
    private final boolean cachingPermitted;
    private final ValueMap<ProcessVar, OWLValue> values;

    public BaseExecutionContext() {
        this(new ValueMap<ProcessVar, OWLValue>(), true);
    }

    public BaseExecutionContext(boolean cachingPermitted) {
        this(new ValueMap<ProcessVar, OWLValue>(), cachingPermitted);
    }

    public BaseExecutionContext(ValueMap<ProcessVar, OWLValue> values) {
        this(values, true);
    }

    public BaseExecutionContext(ValueMap<ProcessVar, OWLValue> values, boolean cachingPermitted) {
        if (values == null) {
            throw new IllegalArgumentException("Process variable map was null.");
        }
        this.cachingPermitted = cachingPermitted;
        this.values = values;
    }

    @Override
    public ValueMap<Input, OWLValue> addInputs(ValueMap<Input, OWLValue> inputs, boolean returnPreviousValues) {
        return this.addValues(inputs, returnPreviousValues);
    }

    @Override
    public ValueMap<Local, OWLValue> addLocals(ValueMap<Local, OWLValue> locals, boolean returnPreviousValues) {
        return this.addValues(locals, returnPreviousValues);
    }

    @Override
    public ValueMap<Output, OWLValue> addOutputs(ValueMap<Output, OWLValue> inputs, boolean returnPreviousValues) {
        return this.addValues(inputs, returnPreviousValues);
    }

    @Override
    public ValueMap<Input, OWLValue> getInputs() {
        return this.getValues(Input.class);
    }

    @Override
    public ValueMap<Local, OWLValue> getLocals() {
        return this.getValues(Local.class);
    }

    @Override
    public ValueMap<Output, OWLValue> getOutputs() {
        return this.getValues(Output.class);
    }

    @Override
    public ValueMap<ProcessVar, OWLValue> getValues() {
        return this.values;
    }

    @Override
    public boolean isCachingPermitted() {
        return this.cachingPermitted;
    }

    private <V extends ProcessVar> ValueMap<V, OWLValue> addValues(ValueMap<V, OWLValue> valueMappings, boolean returnPreviousValues) {
        if (returnPreviousValues) {
            ValueMap<Variable, OWLValue> previousMappings = new ValueMap<Variable, OWLValue>();
            for (Map.Entry<V, OWLValue> entry : valueMappings) {
                previousMappings.setValue((Variable)entry.getKey(), this.values.setValue((ProcessVar)((Variable)entry.getKey()), entry.getValue()));
            }
            return previousMappings;
        }
        for (Map.Entry<V, OWLValue> entry : valueMappings) {
            this.values.setValue((ProcessVar)((Variable)entry.getKey()), entry.getValue());
        }
        return null;
    }

    private <V extends ProcessVar> ValueMap<V, OWLValue> getValues(Class<V> varType) {
        ValueMap<Variable, OWLValue> result = new ValueMap<Variable, OWLValue>();
        for (Map.Entry<ProcessVar, OWLValue> entry : this.values) {
            ProcessVar p = entry.getKey();
            if (!varType.isInstance(p)) continue;
            result.setValue((Variable)varType.cast(p), entry.getValue());
        }
        return result;
    }
}

