/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.execution;

import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.execution.DefaultProcessMonitor;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.Parameter;
import org.mindswap.query.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleThreadedMonitor
extends DefaultProcessMonitor {
    @Override
    public void executionFailed(ExecutionException e) {
        super.executionFailed(e);
        System.out.println("--------------");
    }

    @Override
    public void executionFinished(Process process, ValueMap<Input, OWLValue> inputs, ValueMap<Output, OWLValue> outputs) {
        super.executionFinished(process, inputs, outputs);
        System.out.println("--------------");
    }

    @Override
    public void executionStarted(Process process, ValueMap<Input, OWLValue> inputs) {
        super.executionStarted(process, inputs);
        System.out.println("--------------");
    }

    @Override
    public void executionContinued(Process process) {
        System.out.println("Execution of process: " + process.getLocalName() + " has continued");
        System.out.println("--------------");
    }

    public void executionInterrupted(Process process) {
        System.out.println("Execution of process: " + process.getLocalName() + " has been interrupted");
        System.out.println("--------------");
    }

    public void getExecutionResults(ValueMap<Parameter, OWLValue> values) {
        for (Parameter var : values.getVariables()) {
            System.out.println(values.getStringValue(var));
        }
        System.out.println("--------------");
    }
}

