/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.validator;

import impl.owl.CastingList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.exceptions.CastingException;
import org.mindswap.exceptions.InvalidURIException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AsProcess;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructVisitor;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.InputBinding;
import org.mindswap.owls.process.variable.Local;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.OutputBinding;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.owls.process.variable.ResultVar;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceCategory;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.validator.ValidationException;
import org.mindswap.owls.validator.ValidationMessage;
import org.mindswap.owls.validator.ValidationReport;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.utils.URIUtils;

public class OWLSValidator {
    private static final int CODE_INVALID_VALUE = 0;
    private static final int CODE_MISSING_VALUE = 1;
    private Map<Service, Set<ValidationMessage>> mMessageMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationReport validate(OWLOntology theOntology) throws ValidationException {
        if (theOntology == null) {
            throw ValidationException.createParameterException("OWL ontoloy null", null);
        }
        OWLKnowledgeBase aKb = theOntology.getKB();
        boolean reasonerSet = false;
        if (aKb.getReasoner() == null) {
            aKb.setReasoner("Pellet");
            reasonerSet = true;
        }
        try {
            ValidationReport validationReport = this.validateKb(aKb);
            return validationReport;
        }
        finally {
            if (reasonerSet) {
                aKb.setReasoner(null);
            }
        }
    }

    public ValidationReport validate(String theURI) throws ValidationException {
        try {
            return this.validate(URIUtils.createURI(theURI));
        }
        catch (InvalidURIException e) {
            throw ValidationException.createParameterException("Invalid OWL-S document URI", e);
        }
    }

    public ValidationReport validate(URI theURI) throws ValidationException {
        OWLKnowledgeBase aKb = OWLFactory.createKB();
        aKb.setReasoner("Pellet");
        try {
            aKb.read(theURI);
        }
        catch (IOException ioe) {
            throw ValidationException.createIOException("Failed to read resource " + theURI + ".", ioe);
        }
        catch (Exception ex) {
            throw ValidationException.createParseException("Failed to load OWL-S ontology.", ex);
        }
        return this.validateKb(aKb);
    }

    private ValidationReport validateKb(OWLKnowledgeBase theKb) throws ValidationException {
        this.mMessageMap = new HashMap<Service, Set<ValidationMessage>>();
        if (!theKb.isConsistent()) {
            throw ValidationException.createInconsistencyException("Inconsistent knowledge base.");
        }
        OWLIndividualList<Service> aServiceList = theKb.getServices(false);
        for (Service aService : aServiceList) {
            this.validateService(aService);
        }
        return new ValidationReport(this.mMessageMap);
    }

    private void validateService(Service theService) {
        this.mMessageMap.put(theService, new HashSet());
        this.validateProfileForService(theService);
        this.validateProcessForService(theService);
        this.validateGroundingForService(theService);
    }

    private void validateProcessForService(Service theService) {
        ValidationMessage msg;
        Process theProcess;
        CastingList<Process> processes = OWLFactory.wrapList(theService.getProperties(OWLS_1_2.Service.describedBy), Process.class);
        if (processes.size() > 1) {
            ValidationMessage msg2 = new ValidationMessage(0, "Cannot specify more than one describedBy for a service (" + theService.getLocalName() + ")");
            this.addMessage(theService, msg2);
            return;
        }
        if (processes.isEmpty()) {
            return;
        }
        try {
            theProcess = (Process)processes.get(0);
        }
        catch (CastingException ex) {
            ValidationMessage msg3 = new ValidationMessage(0, "Process individual specified for service (" + theService.getLocalName() + ") is not an instance of " + OWLS_1_2.Process.Process);
            this.addMessage(theService, msg3);
            return;
        }
        try {
            if (theProcess.getProfile() == null) {
                msg = new ValidationMessage(1, "No profile specified for process: " + theProcess.getLocalName());
                this.addMessage(theService, msg);
            }
        }
        catch (CastingException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        if (theProcess.getNames().size() > 1) {
            msg = new ValidationMessage(1, "Process '" + theProcess.getLocalName() + "' can specify at most one name");
            this.addMessage(theService, msg);
        }
        OWLIndividualList<Result> aResultList = theProcess.getResults();
        for (Result aResult : aResultList) {
            this.validateResult(theService, aResult);
        }
        OWLIndividualList<Input> aInputList = theProcess.getInputs();
        for (Input aInput : aInputList) {
            this.validateInput(theService, aInput);
        }
        OWLIndividualList<Output> aOutputList = theProcess.getOutputs();
        for (Output aOutput : aOutputList) {
            this.validateOutput(theService, aOutput);
        }
        if (theProcess.canCastTo(CompositeProcess.class)) {
            this.validateCompositeProcess(theProcess.castTo(CompositeProcess.class));
        } else if (theProcess.canCastTo(AtomicProcess.class)) {
            this.validateAtomicProcess(theProcess.castTo(AtomicProcess.class));
        } else {
            System.err.println("WTF!");
        }
    }

    private void validateLocal(Service theService, Local theLocal) {
        this.validateParameter(theService, theLocal);
    }

    private void validateInput(Service theService, Input theInput) {
        this.validateParameter(theService, theInput);
    }

    private void validateOutput(Service theService, Output theOutput) {
        this.validateParameter(theService, theOutput);
    }

    private void validateParameter(Service theService, ProcessVar theParam) {
        ValidationMessage msg;
        if (theParam.getParamType() == null) {
            msg = new ValidationMessage(1, "A paramType must be specified for ProcessVar: " + theParam.getLocalName());
            this.addMessage(theService, msg);
        }
        if (!theParam.getParamType().isDataType()) {
            msg = new ValidationMessage(0, "The paramType for parameter: '" + theParam.getLocalName() + "' is not specified properly. " + "It is supposed to be a datatype property, but it is specifed as an object property. " + "Please change the declaration.");
            this.addMessage(theService, msg);
        }
    }

    private void validateAtomicProcess(AtomicProcess theAtomicProcess) {
    }

    private void validateCompositeProcess(CompositeProcess theCompositeProcess) {
        Service aService = theCompositeProcess.getService();
        if (theCompositeProcess.getComposedOf() == null) {
            ValidationMessage msg = new ValidationMessage(1, "");
            this.addMessage(theCompositeProcess.getService(), msg);
        }
        ControlConstruct aCC = theCompositeProcess.getComposedOf();
        OWLIndividualList<ControlConstruct> aList = aCC.getConstructs();
        for (ControlConstruct tempCC : aList) {
            this.validateControlConstruct(aService, tempCC);
        }
        try {
            OWLIndividualList<Process> aProcessList = aCC.getAllProcesses(false);
            for (Process aProcess : aProcessList) {
            }
        }
        catch (CastingException ex) {
            this.addMessage(aService, 0, ex.getMessage());
        }
        OWLIndividualList<Local> aParamList = theCompositeProcess.getLocals();
        for (Local aLocal : aParamList) {
            this.validateLocal(aService, aLocal);
        }
    }

    private void validateGroundingForService(Service theService) {
        ValidationMessage msg;
        Grounding<?, ?> aGrounding = null;
        try {
            aGrounding = theService.getGrounding();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (aGrounding == null) {
            ValidationMessage msg2 = new ValidationMessage(1, "No grounding specified for service: " + theService.getLocalName());
            this.addMessage(theService, msg2);
            return;
        }
        if (aGrounding.getProperties(OWLS_1_2.Service.supportedBy).size() > 1) {
            msg = new ValidationMessage(0, "The grounding '" + aGrounding.getLocalName() + "' cannot have more than one supportedBy property");
            this.addMessage(theService, msg);
        }
        if (aGrounding.getService() == null) {
            msg = new ValidationMessage(1, "The grounding '" + aGrounding.getLocalName() + "' does not specify a service.");
            this.addMessage(theService, msg);
        }
        try {
            OWLIndividualList<?> aGroundingList = aGrounding.getAtomicGroundings();
            for (AtomicGrounding aAtomicGrounding : aGroundingList) {
                if (aAtomicGrounding.getProcess() == null) {
                    ValidationMessage msg3 = new ValidationMessage(1, "The atomic grounding '" + aAtomicGrounding.getLocalName() + "' does not specify its process.");
                    this.addMessage(theService, msg3);
                }
                if (aAtomicGrounding.canCastTo(JavaAtomicGrounding.class) || !aAtomicGrounding.canCastTo(WSDLAtomicGrounding.class)) continue;
                this.validateWSDLAtomicGrounding(theService, aAtomicGrounding.castTo(WSDLAtomicGrounding.class));
            }
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
    }

    private void validateWSDLAtomicGrounding(Service theService, WSDLAtomicGrounding theWSDLAtomicGrounding) {
        if (theWSDLAtomicGrounding.getOperationRef() == null) {
            this.addMessage(theService, 0, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' has a missing, or invalid operationRef.");
        } else {
            if (theWSDLAtomicGrounding.getOperationRef().getPortType() == null) {
                this.addMessage(theService, 1, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify a portType for its operationRef.");
            }
            if (theWSDLAtomicGrounding.getOperationRef().getOperation() == null) {
                this.addMessage(theService, 1, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify an operation for its operationRef");
            }
        }
        OWLIndividualList inputMap = theWSDLAtomicGrounding.getInputMappings();
        for (MessageMap messageMap : inputMap) {
            if (messageMap.getGroundingParameter() == null) {
                this.addMessage(theService, 1, "The input map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' requires a grounding parameter (wsdlMessagePart).");
            }
            if (messageMap.getOWLSParameter() != null || messageMap.getTransformation() != null) continue;
            this.addMessage(theService, 1, "The input map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify either an owlsParameter or an xlstTransformation.");
        }
        OWLIndividualList outputMap = theWSDLAtomicGrounding.getOutputMappings();
        for (MessageMap messageMap : outputMap) {
            if (messageMap.getOWLSParameter() == null) {
                this.addMessage(theService, 1, "The output map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' requires an owlsParameter.");
            }
            if (messageMap.getGroundingParameter() != null || messageMap.getTransformation() != null) continue;
            this.addMessage(theService, 1, "The output map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify either an grounding parameter (wsdlMessagePart) or an xlstTransformation.");
        }
    }

    void validateSplitJoin(Service service, SplitJoin theSplitJoin) {
        OWLIndividualList<ControlConstruct> ccBag = theSplitJoin.getConstructs();
        for (ControlConstruct cc : ccBag) {
            this.validateControlConstruct(service, cc);
        }
    }

    private void validateControlConstruct(final Service service, ControlConstruct cc) {
        cc.accept(new ControlConstructVisitor(){

            public void visit(SplitJoin sj) {
                OWLSValidator.this.validateSplitJoin(service, sj);
            }

            public void visit(Split st) {
            }

            public void visit(org.mindswap.owls.process.Set set) {
            }

            public void visit(Sequence sq) {
            }

            public void visit(RepeatWhile rw) {
            }

            public void visit(RepeatUntil ru) {
            }

            public void visit(Produce pr) {
            }

            public void visit(Perform pf) {
                OWLSValidator.this.validatePerform(service, pf);
            }

            public void visit(IfThenElse ite) {
            }

            public void visit(ForEach fe) {
            }

            public void visit(Choice ch) {
            }

            public void visit(AsProcess ap) {
            }

            public void visit(AnyOrder ao) {
            }
        });
    }

    private void validateResult(Service theService, Result theResult) {
        OWLIndividualList<ResultVar> resultVars = theResult.getResultVars();
        for (ResultVar resultVar : resultVars) {
            this.validateParameter(theService, resultVar);
        }
        OWLIndividualList<Expression> effects = theResult.getEffects();
        for (Expression effect : effects) {
        }
        OWLIndividualList<Condition> conditions = theResult.getConditions();
        for (Condition condition : conditions) {
        }
        OWLIndividualList<OutputBinding> aBindingList = theResult.getBindings();
        for (OutputBinding outputBinding : aBindingList) {
            if (outputBinding.getProcessVar() != null) continue;
            this.addMessage(theService, 1, "Result '" + theResult.getLocalName() + "' must specify an Output for its toParam property.");
        }
    }

    void validatePerform(Service theService, Perform thePerform) {
        try {
            if (thePerform.getProcess() == null) {
                ValidationMessage msg = new ValidationMessage(1, "Perform '" + thePerform.getLocalName() + "' must specify a process");
                this.addMessage(theService, msg);
            }
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
        catch (Exception e) {
            this.addMessage(theService, 0, e.getMessage());
        }
        OWLIndividualList<InputBinding> aBindingList = thePerform.getBindings();
        for (InputBinding inputBinding : aBindingList) {
            try {
                if (inputBinding.getProcessVar() != null) continue;
                this.addMessage(theService, 1, "Perform '" + thePerform.getLocalName() + "' must specify an Input for the toParam property.");
            }
            catch (CastingException ex) {
                this.addMessage(theService, 0, ex.getMessage());
            }
            catch (Exception e) {
                this.addMessage(theService, 0, e.getMessage());
            }
        }
    }

    private void validateProfileForService(Service theService) {
        ValidationMessage msg;
        Profile aProfile = null;
        try {
            aProfile = theService.getProfile();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (aProfile == null) {
            ValidationMessage msg2 = new ValidationMessage(1, "No profile specified for service: " + theService.getLocalName());
            this.addMessage(theService, msg2);
            return;
        }
        if (aProfile.getService() == null) {
            msg = new ValidationMessage(1, "No service specified for profile: " + aProfile.getLocalName() + "; double check the presentedBy property on the profile to make sure its correctly specified");
            this.addMessage(theService, msg);
        }
        if (aProfile.getProperties(OWLS_1_2.Profile.serviceName).size() != 1) {
            msg = new ValidationMessage(1, "The profile '" + aProfile.getLocalName() + "' must specify only one serviceName. ");
            this.addMessage(theService, msg);
        }
        if (aProfile.getProperties(OWLS_1_2.Profile.textDescription).size() != 1) {
            msg = new ValidationMessage(1, "The profile '" + aProfile.getLocalName() + "' must specify only one textDescription.");
            this.addMessage(theService, msg);
        }
        if (!aProfile.getInputs().equals(theService.getProcess().getInputs())) {
            msg = new ValidationMessage(0, "Profile inputs for service '" + theService.getLocalName() + "' do not match the process inputs!");
            this.addMessage(theService, msg);
        }
        if (!aProfile.getOutputs().equals(theService.getProcess().getOutputs())) {
            msg = new ValidationMessage(0, "Profile outputs for service '" + theService.getLocalName() + "' do not match the process outputs!");
            this.addMessage(theService, msg);
        }
        OWLIndividualList<ServiceParameter> serviceParameters = aProfile.getServiceParameters();
        for (ServiceParameter serviceParameter : serviceParameters) {
            this.validateServiceParameter(theService, serviceParameter);
        }
        OWLIndividualList<ServiceCategory> serviceCategories = aProfile.getCategories();
        for (ServiceCategory serviceCategory : serviceCategories) {
            this.validateServiceCategory(theService, serviceCategory);
        }
        try {
            if (aProfile.getProcess() == null) {
                ValidationMessage msg3 = new ValidationMessage(1, "Profile '" + aProfile.getLocalName() + "' do not specify a process!");
                this.addMessage(theService, msg3);
            }
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
        catch (NullPointerException npe) {
        }
        catch (Exception e) {
            this.addMessage(theService, 0, e.getMessage());
        }
        OWLIndividualList<Result> aResultList = aProfile.getResults();
        for (Result aResult : aResultList) {
            this.validateResult(theService, aResult);
        }
    }

    private void validateServiceParameter(Service theService, ServiceParameter theServiceParameter) {
        ValidationMessage msg;
        if (theServiceParameter.getName() == null) {
            msg = new ValidationMessage(1, "Must specify a name for serviceParameter: " + theServiceParameter.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceParameter.getParameter() == null) {
            msg = new ValidationMessage(1, "Must specify a parameter for serviceParameter: " + theServiceParameter.getLocalName());
            this.addMessage(theService, msg);
        }
    }

    private void validateServiceCategory(Service theService, ServiceCategory theServiceCategory) {
        ValidationMessage msg;
        if (theServiceCategory.getCode() == null) {
            msg = new ValidationMessage(1, "Must specify a code for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getValue() == null) {
            msg = new ValidationMessage(1, "Must specify a value for serviceCategory " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getTaxonomy() == null) {
            msg = new ValidationMessage(1, "Must specify a taxonomy for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getName() == null) {
            msg = new ValidationMessage(1, "Must specify a name for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
    }

    private void addMessage(Service theService, int theCode, String theMsg) {
        this.addMessage(theService, new ValidationMessage(theCode, theMsg));
    }

    private void addMessage(Service theService, ValidationMessage theMsg) {
        Set<ValidationMessage> aSet = this.mMessageMap.get(theService);
        if (aSet == null) {
            aSet = new HashSet<ValidationMessage>();
        }
        aSet.add(theMsg);
        this.mMessageMap.put(theService, aSet);
    }

    public static void main(String[] args) {
        System.err.println("validator main");
        try {
            new OWLSValidator().validate(new File("composite.owl").toURI()).print(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

