/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.validator;

public class ValidationException
extends Exception {
    private static final long serialVersionUID = 77924528831606623L;
    private final Error mId;

    public ValidationException(Error theId, String theMsg) {
        super(theMsg);
        this.mId = theId;
    }

    public ValidationException(Error theId, String theMsg, Throwable cause) {
        super(theMsg, cause);
        this.mId = theId;
    }

    public Error getId() {
        return this.mId;
    }

    public static final ValidationException createParameterException(String theMsg, Throwable cause) {
        return ValidationException.create(Error.PARAMETER, theMsg, cause);
    }

    public static final ValidationException createParseException(String theMsg, Throwable cause) {
        return ValidationException.create(Error.PARSE, theMsg, cause);
    }

    public static final ValidationException createIOException(String theMsg, Throwable cause) {
        return ValidationException.create(Error.IO, theMsg, cause);
    }

    public static final ValidationException createInconsistencyException(String theMsg) {
        return ValidationException.create(Error.INCONSISTENCY, theMsg, null);
    }

    private static ValidationException create(Error code, String msg, Throwable cause) {
        return cause == null ? new ValidationException(code, msg) : new ValidationException(code, msg, cause);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error {
        PARSE,
        IO,
        PARAMETER,
        INCONSISTENCY;

    }
}

