/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.validator;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.validator.ValidationMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationReport
implements Iterable<Map.Entry<Service, Set<ValidationMessage>>> {
    private final Map<Service, Set<ValidationMessage>> messageMap;

    public ValidationReport(Map<Service, Set<ValidationMessage>> theMsgs) {
        this.messageMap = theMsgs;
    }

    public boolean isEmpty() {
        for (Map.Entry<Service, Set<ValidationMessage>> e : this.messageMap.entrySet()) {
            if (e.getValue().size() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isValid(Service service) {
        return this.messageMap.containsKey(service) && this.messageMap.get(service).isEmpty();
    }

    @Override
    public Iterator<Map.Entry<Service, Set<ValidationMessage>>> iterator() {
        return this.messageMap.entrySet().iterator();
    }

    public void print(PrintStream theOut) {
        theOut.println("Validation Report");
        if (this.messageMap.isEmpty()) {
            theOut.println("Valid:\ttrue");
            return;
        }
        for (Map.Entry<Service, Set<ValidationMessage>> entry : this.messageMap.entrySet()) {
            Service aService = entry.getKey();
            Set<ValidationMessage> msgSet = entry.getValue();
            boolean valid = msgSet.isEmpty();
            theOut.println("Service:\t" + aService);
            theOut.println("Valid:\t\t" + valid);
            if (valid) continue;
            theOut.println("Validation messages: ");
            for (ValidationMessage msg : msgSet) {
                theOut.println(msg);
            }
        }
    }

    public Map<Service, Set<ValidationMessage>> getMessages() {
        return this.messageMap;
    }
}

