/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mindswap.common.ClosableIterator;
import org.mindswap.common.Variable;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.query.Query;
import org.mindswap.query.QueryLanguage;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.SWRLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABoxQuery<V extends Variable>
implements Query<V> {
    private final OWLList<Atom> body;
    private final List<V> resultVars;
    private Query<V> query;

    public ABoxQuery(OWLList<Atom> body, Collection<V> resultVars) {
        this.body = body;
        this.resultVars = new ArrayList<V>(resultVars);
    }

    @Override
    public ABoxQuery<V> attach(OWLModel model) {
        this.query = model.makeQuery(this);
        return this;
    }

    public void addResultVar(V var) {
        this.resultVars.add(var);
        this.query = null;
    }

    public void addResultVars(Collection<V> vars) {
        this.resultVars.addAll(vars);
        this.query = null;
    }

    public OWLList<Atom> getBody() {
        return this.body;
    }

    @Override
    public QueryLanguage getQueryLanguage() {
        return QueryLanguage.ABox;
    }

    @Override
    public List<V> getResultVariables() {
        return Collections.unmodifiableList(this.resultVars);
    }

    public List<Variable> getVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Atom atom : this.body) {
            for (int j = 0; j < atom.getArgumentCount(); ++j) {
                SWRLObject term = atom.getArgument(j);
                if (!term.isVariable()) continue;
                vars.add((Variable)((Object)term));
            }
        }
        return vars;
    }

    @Override
    public ClosableIterator<ValueMap<V, OWLValue>> execute(ValueMap<?, ?> binding) {
        if (this.query == null) {
            throw new IllegalStateException("Query is not attached to OWLModel.");
        }
        return this.query.execute(binding);
    }

    public String toString() {
        return "query(" + this.getResultVariables() + ") :- " + this.getBody().toString();
    }
}

