/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.common.Variable;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMap<V extends Variable, W extends OWLValue>
implements Iterable<Map.Entry<V, W>> {
    @Deprecated
    public static final ValueMap EMPTY_VALUE_MAP = new ValueMap(Collections.EMPTY_MAP);
    private final Map<V, W> map;

    public ValueMap() {
        this(new HashMap());
    }

    public ValueMap(Map<V, W> mappings) {
        assert (mappings != null) : "Invalid: Map is null.";
        this.map = mappings;
    }

    public W setValue(V var, W value) {
        if (var == null) {
            throw new NullPointerException("ValueMap cannot set a value for null variable");
        }
        return (W)((OWLValue)this.map.put(var, value));
    }

    public W getValue(Variable var) {
        return (W)((OWLValue)this.map.get(var));
    }

    public OWLDataValue getDataValue(Variable var) {
        return (OWLDataValue)this.map.get(var);
    }

    public OWLDataValue getDataValue(String var) {
        return (OWLDataValue)this.getValue(var);
    }

    public String getStringValue(Variable var) {
        OWLValue tmp = (OWLValue)this.map.get(var);
        return tmp == null ? null : tmp.toString();
    }

    public String getStringValue(String var) {
        W tmp = this.getValue(var);
        return tmp == null ? null : tmp.toString();
    }

    public OWLIndividual getIndividualValue(Variable var) {
        return (OWLIndividual)this.map.get(var);
    }

    public OWLIndividual getIndividualValue(String var) {
        return (OWLIndividual)this.getValue(var);
    }

    public W getValue(String varName) {
        for (Map.Entry<V, W> e : this.map.entrySet()) {
            Variable var = (Variable)e.getKey();
            String varname = var.getName();
            if (varname == null || !varname.equals(varName)) continue;
            return (W)((OWLValue)e.getValue());
        }
        return null;
    }

    public boolean hasValue(Variable var) {
        return this.map.containsKey(var);
    }

    public OWLValue removeValue(Variable var) {
        return (OWLValue)this.map.remove(var);
    }

    public void clear() {
        this.map.clear();
    }

    public void putMap(ValueMap<? extends V, ? extends W> valueMap) {
        this.map.putAll(valueMap.map);
    }

    public Set<V> getVariables() {
        return this.map.keySet();
    }

    public Collection<W> getValues() {
        return this.map.values();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public String debugString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<V, W>> i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<V, W> entry = i.next();
            Variable var = (Variable)entry.getKey();
            OWLValue val = (OWLValue)entry.getValue();
            String value = val == null ? "null" : (val.isDataValue() ? val.toString() : ((OWLIndividual)val).toRDF(false, true));
            sb.append("(").append(var.getName()).append(" = ").append(value).append(")");
            if (!i.hasNext()) continue;
            sb.append(" & ");
        }
        return sb.toString();
    }

    @Override
    public Iterator<Map.Entry<V, W>> iterator() {
        return this.map.entrySet().iterator();
    }

    public static final <V extends Variable, W extends OWLValue> ValueMap<V, W> emptyValueMap() {
        return EMPTY_VALUE_MAP;
    }

    public static final <V extends Variable, W extends OWLValue> ValueMap<V, W> unmodifyableValueMap(ValueMap<V, W> vm) {
        return new ValueMap<V, W>(Collections.unmodifiableMap(vm.map));
    }
}

