/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.net.URI;
import org.mindswap.common.ClosableIterator;
import org.mindswap.common.OrdinaryVariable;
import org.mindswap.common.Variable;
import org.mindswap.exceptions.ParseException;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.variable.Parameter;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.owls.vocabulary.OWLS_Extensions;
import org.mindswap.query.QueryLanguage;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDataFlow {
    private final OWLOntology ontology;

    public ProcessDataFlow(OWLOntology indexOnt) {
        this.ontology = indexOnt;
    }

    public OWLOntology asOntology() {
        return this.ontology;
    }

    public OWLType getMostSpecificSinkType(ProcessVar source) {
        OWLDataValue msstDV = this.ontology.getProperty((OWLIndividual)source, OWLS_Extensions.Process.mssType);
        return this.ontology.getKB().getType((URI)msstDV.getValue());
    }

    public OWLIndividualList<Parameter> getSinkParameters(ProcessVar source) {
        return OWLFactory.castList(this.ontology.getProperties((OWLIndividual)source, OWLS_Extensions.Process.connectedTo), Parameter.class);
    }

    public String toString() {
        ClosableIterator<ValueMap<Variable, OWLValue>> results;
        OrdinaryVariable source = new OrdinaryVariable("source");
        OrdinaryVariable sink = new OrdinaryVariable("sink");
        OrdinaryVariable msst = new OrdinaryVariable("msst");
        String query = "SELECT " + source + " " + sink + " " + msst + " " + "WHERE { " + source + " <" + OWLS_Extensions.Process.connectedTo.getURI() + "> " + sink + ";" + " <" + OWLS_Extensions.Process.mssType.getURI() + "> " + msst + "." + " } ORDER BY " + source;
        try {
            results = this.ontology.makeQuery(query, QueryLanguage.SPARQL).execute(null);
        }
        catch (ParseException e) {
            return "toString failure - details: " + e;
        }
        StringBuffer line = null;
        StringBuffer all = new StringBuffer();
        while (results.hasNext()) {
            ValueMap result = (ValueMap)results.next();
            String sou = this.getShortName(result.getIndividualValue(source));
            String sin = this.getShortName(result.getIndividualValue(sink));
            if (line != null && line.indexOf(sou) == 0) {
                line.append(", ").append(sin);
                continue;
            }
            this.finishLine(line, all);
            line = new StringBuffer();
            line.append(sou).append(" [msst = ").append(result.getValue(msst)).append("]");
            line.append(" ~~> {").append(sin);
        }
        this.finishLine(line, all);
        return all.toString();
    }

    private void finishLine(StringBuffer line, StringBuffer all) {
        if (line != null) {
            line.append("}").append(Utils.LINE_SEPARATOR);
            all.append(line);
        }
    }

    private String getShortName(OWLEntity entity) {
        return entity.isAnon() ? "_" + entity.getAnonID() : entity.getLocalName();
    }

    public static final ProcessDataFlow index(OWLOntology ont, Process process) {
        return process.getDataFlow(ont);
    }
}

