/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.common.ClosableIterator;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLIndividualObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);

    public static Map<Input, Set<OWLValue>> getAllowedValues(Process process) {
        return ProcessUtils.getAllowedValues(process.getInputs(), process.getConditions(), new ValueMap(), process.getKB());
    }

    public static Map<Input, Set<OWLValue>> getAllowedValues(Process process, ValueMap<Input, ?> initialBinding) {
        return ProcessUtils.getAllowedValues(process.getInputs(), process.getConditions(), initialBinding, process.getKB());
    }

    public static final <V extends ProcessVar> Map<V, Set<OWLValue>> getAllowedValues(OWLIndividualList<V> procVars, OWLIndividualList<? extends Expression> constraints, ValueMap<V, ?> initialBindings, OWLKnowledgeBase kb) {
        Expression constraint;
        if (constraints.size() > 1) {
            logger.warn("Multiple constraints are not supported, taking into account the first constraint only!");
        }
        if ((constraint = constraints.isEmpty() ? null : (Expression)constraints.get(0)) == null || constraint instanceof Expression.SWRL) {
            return ProcessUtils.getAllowedValuesSWRL(procVars, (Expression.SWRL)constraint, initialBindings, kb);
        }
        throw new NotImplementedException("Support for expression languages other than SRWL not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <V extends ProcessVar> Map<V, Set<OWLValue>> getAllowedValuesSWRL(OWLIndividualList<V> procVars, Expression.SWRL constraint, ValueMap<V, ?> initBinding, OWLKnowledgeBase kb) {
        SWRLFactory.ISWRLFactory swrlFactory = SWRLFactory.createFactory(kb);
        OWLList<ClassAtom> atoms = null;
        atoms = constraint == null ? swrlFactory.createList() : (OWLList<ClassAtom>)constraint.getBody();
        HashMap allowedValues = new HashMap();
        ArrayList<ProcessVar> resultVars = new ArrayList<ProcessVar>();
        for (ProcessVar procVar : procVars) {
            OWLType inputType;
            if (initBinding.hasValue(procVar) || !(inputType = procVar.getParamType()).isClass()) continue;
            allowedValues.put(procVar, new HashSet());
            resultVars.add(procVar);
            ClassAtom typeAtom = swrlFactory.createClassAtom((OWLClass)inputType, procVar.castTo(SWRLIndividualObject.class));
            atoms = atoms.cons(typeAtom);
        }
        ClosableIterator results = kb.makeQuery((OWLList<Atom>)atoms, resultVars).execute(initBinding);
        try {
            while (results.hasNext()) {
                ValueMap binding = (ValueMap)results.next();
                for (Map.Entry entry : binding) {
                    ProcessVar procVariable = (ProcessVar)entry.getKey();
                    Set set = (Set)allowedValues.get(procVariable);
                    if (set == null) continue;
                    set.add(entry.getValue());
                }
            }
        }
        finally {
            results.close();
        }
        return allowedValues;
    }
}

