/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.IOException;
import java.io.StringReader;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.vocabulary.RDF;

public class RDFUtils {
    public static final String addRDFTag(String rdf) {
        return "<rdf:RDF xmlns:rdf=\"" + RDF.getURI() + "\">" + rdf + "</rdf:RDF>";
    }

    public static final boolean hasRDFTag(String rdf) {
        return (rdf = rdf.trim()).length() > 0 && rdf.startsWith("<rdf:RDF") && rdf.endsWith("</rdf:RDF>");
    }

    public static final String removeRDFTag(String rdf, boolean inlineNamespaces) {
        int openingRDFTagBegin = rdf.indexOf("<rdf:RDF");
        int openingRDFTagEnd = rdf.indexOf(">", openingRDFTagBegin + 8);
        int closingRDFTagBegin = rdf.indexOf("</rdf:RDF>", openingRDFTagEnd + 1);
        if (inlineNamespaces) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(rdf.substring(0, openingRDFTagEnd + 1));
            buffer.append("<rdf:Description><rdfs:label rdf:parseType=\"Literal\">");
            buffer.append(rdf.substring(openingRDFTagEnd + 1, closingRDFTagBegin));
            buffer.append("</rdfs:label></rdf:Description>");
            buffer.append(rdf.substring(closingRDFTagBegin));
            OWLKnowledgeBase kb = OWLFactory.createKB();
            OWLOntology ont = null;
            try {
                ont = kb.read(new StringReader(buffer.toString()), null);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Given RDF string seems to have invalid syntax.", e);
            }
            OWLIndividual ind = (OWLIndividual)ont.getIndividuals(true).get(0);
            rdf = ind.getLabel(null);
        } else {
            rdf = rdf.substring(openingRDFTagEnd + 1, closingRDFTagBegin);
        }
        return rdf;
    }

    public static final OWLDataValue toXMLLiteral(OWLIndividual ind) {
        return ind.getOntology().createDataValue((Object)ind.toRDF(false, true), RDF.XMLLiteral);
    }
}

