/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.JavaParameter;
import org.mindswap.owls.grounding.JavaVariable;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLGrounding;
import org.mindswap.owls.grounding.WSDLOperationRef;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceGenerator {
    public static final URI DEFAULT_BASE_URI = URI.create("http://www.example.org/ont");
    private static final Logger logger = LoggerFactory.getLogger(ServiceGenerator.class);
    URI base;
    final Random r = new Random();
    final OWLKnowledgeBase kb;
    final List<OWLClass> owlClasses;

    public ServiceGenerator(OWLKnowledgeBase target, URI ... ontologies) throws IOException {
        URI[] uRIArray;
        OWLKnowledgeBase oWLKnowledgeBase = this.kb = target != null ? target : OWLFactory.createKB();
        if (ontologies == null || ontologies.length == 0) {
            URI[] uRIArray2 = new URI[1];
            uRIArray = uRIArray2;
            uRIArray2[0] = URI.create("http://www.lehigh.edu/%7Ezhp2/2004/0401/univ-bench.owl");
        } else {
            uRIArray = ontologies;
        }
        ontologies = uRIArray;
        this.owlClasses = new ArrayList<OWLClass>();
        for (URI ont : ontologies) {
            OWLOntology lubmOnt = this.kb.read(ont);
            this.owlClasses.addAll(lubmOnt.getClasses(true));
        }
    }

    public void generateAtomicServices(URI baseURI, int numberOfServices, boolean useSubModels, boolean logProgress) {
        this.generateAtomicServices(baseURI, numberOfServices, 2, 2, useSubModels, logProgress);
    }

    public void generateAtomicServices(URI baseURI, int numberOfServices, int numberOfInputs, int numberOfOutputs, boolean useSubModels, boolean logProgress) {
        assert (numberOfServices > 0) : "Number of services must be larger than zero";
        this.base = baseURI != null ? baseURI : DEFAULT_BASE_URI;
        float logThreshold = (float)numberOfServices / 10.0f;
        long time = System.currentTimeMillis();
        for (int i = 1; i <= numberOfServices; ++i) {
            OWLOntology ont = this.getTargetOntology(useSubModels, Integer.toString(i));
            this.generate(i, numberOfInputs, numberOfOutputs, ont);
            this.logProgress(logProgress, "services", logThreshold, i, numberOfServices);
        }
        this.logNumbers(System.currentTimeMillis() - time);
    }

    public void generateStatements(URI baseURI, int numberOfStatements, boolean logProgress) {
        long initialNumberOfStatements;
        assert (numberOfStatements >= 1) : "Minimum number of statements is 1";
        this.base = baseURI != null ? baseURI : DEFAULT_BASE_URI;
        float logThreshold = (float)numberOfStatements / 10.0f;
        long time = System.currentTimeMillis();
        OWLIndividualList<? extends Process> processes = this.kb.getProcesses(1, false);
        if (processes.size() < 1) {
            this.generateAtomicServices(baseURI, 1, false, false);
            processes = this.kb.getProcesses(1, false);
        }
        if ((long)numberOfStatements <= (initialNumberOfStatements = this.kb.size())) {
            logger.info("No statements generated: Initial size of KB {} >= {}", (Object)initialNumberOfStatements, (Object)numberOfStatements);
            return;
        }
        AtomicProcess process = (AtomicProcess)processes.get(0);
        Service service = process.getService();
        Profile profile = service.getProfile();
        AtomicGrounding<?> grounding = process.getGrounding();
        OWLObjectProperty[] properties = new OWLObjectProperty[20];
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = this.kb.createObjectProperty(URIUtils.createURI(this.base, "objProp" + i));
        }
        Callable<Integer> callable = grounding instanceof JavaAtomicGrounding ? new JavaGroundingExtender((JavaAtomicGrounding)grounding, properties) : new MessageMapBasedGroundingExtender(grounding, properties);
        long i = this.kb.size();
        while (i < (long)numberOfStatements) {
            process.addProperty(properties[this.r.nextInt(properties.length)], this.kb.createIndividual(this.owlClasses.get(this.r.nextInt(this.owlClasses.size())).getURI(), URIUtils.createURI(this.base, "ind" + i++)));
            service.addProperty(properties[this.r.nextInt(properties.length)], this.kb.createIndividual(this.owlClasses.get(this.r.nextInt(this.owlClasses.size())).getURI(), URIUtils.createURI(this.base, "ind" + i++)));
            profile.addProperty(properties[this.r.nextInt(properties.length)], this.kb.createIndividual(this.owlClasses.get(this.r.nextInt(this.owlClasses.size())).getURI(), URIUtils.createURI(this.base, "ind" + i++)));
            grounding.addProperty(properties[this.r.nextInt(properties.length)], this.kb.createIndividual(this.owlClasses.get(this.r.nextInt(this.owlClasses.size())).getURI(), URIUtils.createURI(this.base, "ind" + i++)));
            i += 4L;
            try {
                i += (long)callable.call().intValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.logProgress(logProgress, "statements", logThreshold, i, numberOfStatements);
        }
        this.logNumbers(System.currentTimeMillis() - time);
    }

    public List<OWLClass> getOWLClasses() {
        return Collections.unmodifiableList(this.owlClasses);
    }

    public OWLKnowledgeBase getKnowledgeBase() {
        return this.kb;
    }

    public static void main(String[] args) throws IOException {
        ServiceGenerator gen = new ServiceGenerator(OWLFactory.createKB(), new URI[0]);
        int numberOfServices = args != null && args.length > 0 ? Integer.parseInt(args[0]) : 1;
        logger.info("Generating {} service(s)", (Object)numberOfServices);
        gen.generateAtomicServices(null, numberOfServices, -3, -3, false, true);
        gen.getKnowledgeBase().setReasoner("Pellet");
        gen.getKnowledgeBase().classify();
        gen.getKnowledgeBase().write(System.out, null);
    }

    private void generate(int i, int in, int out, OWLOntology ont) {
        MessageMap<String> msgMap;
        int j;
        Service service = ont.createService(URIUtils.createURI(this.base, "Service" + i));
        Profile profile = ont.createProfile(URIUtils.createURI(this.base, "Profile" + i));
        AtomicProcess process = ont.createAtomicProcess(URIUtils.createURI(this.base, "Process" + i));
        WSDLGrounding groundg = ont.createWSDLGrounding(URIUtils.createURI(this.base, "Grounding" + i));
        WSDLAtomicGrounding atgrdg = ont.createWSDLAtomicGrounding(URIUtils.createURI(this.base, "AtomicGrounding" + i));
        service.setName("Service" + i);
        service.addProfile(profile);
        service.setProcess(process);
        service.addGrounding(groundg);
        groundg.addGrounding(atgrdg);
        atgrdg.setProcess(process);
        URI wsdlBase = URI.create(this.base + "?wsdl");
        atgrdg.setWSDL(wsdlBase);
        WSDLOperationRef operation = ont.createWSDLOperationRef(null);
        operation.setOperation(URIUtils.createURI(wsdlBase, "operation" + i));
        operation.setPortType(URIUtils.createURI(wsdlBase, "port" + i));
        atgrdg.setOperationRef(operation);
        atgrdg.setInputMessage(URIUtils.createURI(wsdlBase, "request" + i));
        atgrdg.setOutputMessage(URIUtils.createURI(wsdlBase, "reply" + i));
        profile.setTextDescription("Profile" + i + " description");
        process.setLabel("Process" + i + " description", null);
        int n = in < 0 ? this.r.nextInt(Math.abs(in) + 1) : in;
        for (j = 1; j <= n; ++j) {
            Input input = ont.createInput(URIUtils.createURI(this.base, "Input" + j + "." + i));
            input.setParamType(this.owlClasses.get(this.r.nextInt(this.owlClasses.size())));
            profile.addInput(input);
            process.addInput(input);
            msgMap = ont.createWSDLInputMessageMap(null);
            msgMap.setGroundingParameter(wsdlBase + "#Input" + j + "." + i);
            msgMap.setOWLSParameter(input);
            atgrdg.addInputMap(msgMap);
        }
        n = out < 0 ? this.r.nextInt(Math.abs(out) + 1) : out;
        for (j = 1; j <= n; ++j) {
            Output output = ont.createOutput(URIUtils.createURI(this.base, "Output" + j + "." + i));
            output.setParamType(this.owlClasses.get(this.r.nextInt(this.owlClasses.size())));
            profile.addOutput(output);
            process.addOutput(output);
            msgMap = ont.createWSDLOutputMessageMap(null);
            msgMap.setGroundingParameter(wsdlBase + "#Output" + j + "." + i);
            msgMap.setOWLSParameter(output);
            atgrdg.addOutputMap(msgMap);
        }
    }

    private OWLOntology getTargetOntology(boolean useSubModels, String suffix) {
        if (useSubModels) {
            return this.kb.createOntology(URI.create(this.base + "/" + suffix));
        }
        return (OWLOntology)this.kb.getBaseModel();
    }

    private void logNumbers(long time) {
        logger.info(new Formatter().format("Generation took %.1fs", Float.valueOf((float)time / 1000.0f)).toString());
        logger.info(new Formatter().format("Final KB size   %d statements", this.kb.size()).toString());
        System.gc();
        logger.info(new Formatter().format("Total memory    %.2fMB", Float.valueOf((float)Runtime.getRuntime().totalMemory() / 1024.0f / 1024.0f)).toString());
    }

    private void logProgress(boolean logProgress, String what, float threshold, long current, int maximum) {
        if (logProgress && (float)current % threshold < 1.0f) {
            logger.info("{} {} generated; number of statements in KB {}", new Object[]{current, what, maximum > 10000 ? "-" : Long.valueOf(this.kb.size())});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MessageMapBasedGroundingExtender
    implements Callable<Integer> {
        private final OWLIndividualList<? extends MessageMap<?>> inputMappings;
        private final OWLIndividualList<? extends MessageMap<?>> outputMappings;
        private final OWLObjectProperty[] properties;
        private int i = 0;

        MessageMapBasedGroundingExtender(AtomicGrounding<?> grounding, OWLObjectProperty[] properties) {
            this.inputMappings = grounding.getInputMappings();
            this.outputMappings = grounding.getInputMappings();
            this.properties = properties;
        }

        @Override
        public Integer call() {
            for (MessageMap messageMap : this.inputMappings) {
                messageMap.addProperty(this.properties[ServiceGenerator.this.r.nextInt(this.properties.length)], ServiceGenerator.this.kb.createIndividual(ServiceGenerator.this.owlClasses.get(ServiceGenerator.this.r.nextInt(ServiceGenerator.this.owlClasses.size())).getURI(), URIUtils.createURI(ServiceGenerator.this.base, "ind" + this.i++)));
            }
            for (MessageMap messageMap : this.outputMappings) {
                messageMap.addProperty(this.properties[ServiceGenerator.this.r.nextInt(this.properties.length)], ServiceGenerator.this.kb.createIndividual(ServiceGenerator.this.owlClasses.get(ServiceGenerator.this.r.nextInt(ServiceGenerator.this.owlClasses.size())).getURI(), URIUtils.createURI(ServiceGenerator.this.base, "ind" + this.i++)));
            }
            return 2 * (this.inputMappings.size() + this.outputMappings.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JavaGroundingExtender
    implements Callable<Integer> {
        private final OWLIndividualList<JavaParameter> inputs;
        private final JavaVariable output;
        private final OWLObjectProperty[] properties;
        private int i = 0;

        JavaGroundingExtender(JavaAtomicGrounding grounding, OWLObjectProperty[] properties) {
            this.properties = properties;
            this.inputs = grounding.getInputParameters();
            this.output = grounding.getOutput();
        }

        @Override
        public Integer call() {
            for (JavaParameter input : this.inputs) {
                input.addProperty(this.properties[ServiceGenerator.this.r.nextInt(this.properties.length)], ServiceGenerator.this.kb.createIndividual(ServiceGenerator.this.owlClasses.get(ServiceGenerator.this.r.nextInt(ServiceGenerator.this.owlClasses.size())).getURI(), URIUtils.createURI(ServiceGenerator.this.base, "ind" + this.i++)));
            }
            int generatedStatements = 2 * this.inputs.size();
            if (this.output != null) {
                this.output.addProperty(this.properties[ServiceGenerator.this.r.nextInt(this.properties.length)], ServiceGenerator.this.kb.createIndividual(ServiceGenerator.this.owlClasses.get(ServiceGenerator.this.r.nextInt(ServiceGenerator.this.owlClasses.size())).getURI(), URIUtils.createURI(ServiceGenerator.this.base, "ind" + this.i++)));
                generatedStatements += 2;
            }
            return generatedStatements;
        }
    }
}

