/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator") != null ? System.getProperty("line.separator") : "\n";
    static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();

    public static <K, V> K getMapKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Node getAsNode(String in) {
        try {
            DocumentBuilder parser = parserFactory.newDocumentBuilder();
            parser.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) {
                    logger.debug("XML parser warning {}", (Object)exception.toString());
                }

                public void error(SAXParseException exception) {
                    logger.debug("XML parser error {}", (Object)exception.toString());
                }

                public void fatalError(SAXParseException exception) {
                    logger.debug("XML parser fatal error", (Throwable)exception);
                }
            });
            return parser.parse(new InputSource(new StringReader(in))).getDocumentElement();
        }
        catch (Exception e) {
            logger.debug("Exception while XML parsing. Details: {}", (Object)e.toString());
            return null;
        }
    }

    public static String readURL(URL fileURL) throws IOException {
        return Utils.readAll(new InputStreamReader(fileURL.openStream()));
    }

    public static String readFile(String fileName) throws IOException {
        return Utils.readAll(new FileReader(fileName));
    }

    public static String readAll(Reader reader) throws IOException {
        int ch;
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((ch = in.read()) > -1) {
            buffer.append((char)ch);
        }
        in.close();
        return buffer.toString();
    }

    public static String formatRDF(String rdf) {
        Node node = Utils.getAsNode(rdf);
        if (node == null) {
            return rdf;
        }
        return Utils.formatNode(node, " ").substring(LINE_SEPARATOR.length());
    }

    public static String formatNode(Node node, String indent) {
        switch (node.getNodeType()) {
            case 3: {
                return node.getNodeValue().trim();
            }
            case 1: {
                NodeList children;
                StringBuilder sb = new StringBuilder();
                if (!(node.getParentNode() instanceof Document)) {
                    sb.append(LINE_SEPARATOR).append(indent).append(node.getLocalName()).append(": ");
                }
                if ((children = node.getChildNodes()) != null) {
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        sb.append(Utils.formatNode(children.item(i), indent + "  "));
                    }
                } else {
                    Node rdfRes = node.getAttributes().getNamedItemNS(RDF.getURI().toString(), "resource");
                    if (rdfRes instanceof Attr) {
                        sb.append(URIUtils.getLocalName(((Attr)rdfRes).getValue()));
                    }
                }
                return sb.toString();
            }
        }
        return "";
    }

    static {
        parserFactory.setNamespaceAware(true);
    }
}

