/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mindswap.exceptions.TransformationException;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.query.ValueMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTEngine {
    private static final String header = "<?xml";
    private static TransformerFactory tFactory;

    public static String transform(Node input, String xslt) throws TransformationException {
        return XSLTEngine.transformToString(new DOMSource(input), xslt, ValueMap.emptyValueMap());
    }

    public static String transform(String input, String xslt) throws TransformationException {
        return XSLTEngine.transform(input, xslt, ValueMap.emptyValueMap());
    }

    public static <V extends ProcessVar, W extends OWLValue> String transform(String input, String xslt, ValueMap<V, W> parameters) throws TransformationException {
        return XSLTEngine.transformToString(new StreamSource(new StringReader(input)), xslt, parameters);
    }

    public static <V extends ProcessVar, W extends OWLValue> Node transformToNode(String input, String xslt, ValueMap<V, W> parameters) throws TransformationException {
        if (xslt == null) {
            throw new TransformationException("Required XSLT stylesheet missing");
        }
        DOMResult result = new DOMResult();
        XSLTEngine.transform(new StreamSource(new StringReader(input)), result, xslt.trim(), parameters);
        return result.getNode();
    }

    private static <V extends ProcessVar, W extends OWLValue> String transformToString(Source input, String xslt, ValueMap<V, W> parameters) throws TransformationException {
        if (xslt == null) {
            throw new TransformationException("Required XSLT stylesheet missing");
        }
        StringWriter result = new StringWriter();
        XSLTEngine.transform(input, new StreamResult(result), xslt.trim(), parameters);
        String output = result.toString().trim();
        if (output.startsWith(header)) {
            int split = output.indexOf(62) + 1;
            output = output.substring(split);
        }
        return output;
    }

    private static <V extends ProcessVar, W extends OWLValue> void transform(Source source, Result result, String xslt, ValueMap<V, W> parameters) throws TransformationException {
        try {
            Transformer transformer = XSLTEngine.getTransformerFactory().newTransformer(new StreamSource(new StringReader(xslt)));
            for (ProcessVar param : parameters.getVariables()) {
                String value = parameters.getStringValue(param);
                transformer.setParameter(param.getLocalName(), value);
                transformer.setParameter(param.getURI().toString(), value);
            }
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    private static final TransformerFactory getTransformerFactory() {
        if (tFactory == null) {
            tFactory = TransformerFactory.newInstance();
        }
        return tFactory;
    }
}

