/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.constants.Enum;
import org.apache.axis.constants.Style;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.mindswap.utils.URIUtils;
import org.mindswap.utils.Utils;
import org.mindswap.wsdl.WSDLConsts;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLOperation {
    private static final Logger logger = LoggerFactory.getLogger(WSDLOperation.class);
    private WSDLService service = null;
    private final Call call;
    private final Vector<WSDLParameter> inputs;
    private final Vector<WSDLParameter> outputs;
    private String operationName;
    private String inputMessageName;
    private String outputMessageName;
    private String portName;
    private String documentation;
    private SOAPElement response;

    public WSDLOperation(Call c) {
        this.call = c;
        this.inputs = new Vector();
        this.outputs = new Vector();
    }

    public WSDLParameter getInput(int i) {
        return this.getInputs().elementAt(i);
    }

    public WSDLParameter getInput(String name) {
        for (WSDLParameter in : this.inputs) {
            String paramName = in.getName();
            if (!paramName.equals(name) && !URIUtils.getLocalName(paramName).equals(name)) continue;
            return in;
        }
        return null;
    }

    public WSDLParameter getOutput(int i) {
        return this.getOutputs().elementAt(i);
    }

    public WSDLParameter getOutput(String name) {
        for (WSDLParameter out : this.outputs) {
            String paramName = out.getName();
            if (!paramName.equals(name) && !URIUtils.getLocalName(paramName).equals(name)) continue;
            return out;
        }
        return null;
    }

    public Vector<WSDLParameter> getInputs() {
        return this.inputs;
    }

    public Vector<WSDLParameter> getOutputs() {
        return this.outputs;
    }

    void addInput(String name, QName type) {
        this.inputs.add(new WSDLParameter(name, type));
    }

    void addOutput(String name, QName type) {
        this.outputs.add(new WSDLParameter(name, type));
    }

    public String getName() {
        return this.call.getOperationName().getLocalPart();
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String s) {
        this.operationName = s;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String s) {
        this.portName = s;
    }

    public String getInputMessageName() {
        return this.inputMessageName;
    }

    public void setInputMessageName(String s) {
        this.inputMessageName = s;
    }

    public String getOutputMessageName() {
        return this.outputMessageName;
    }

    public void setOutputMessageName(String s) {
        this.outputMessageName = s;
    }

    public WSDLService getService() {
        return this.service;
    }

    public void setService(WSDLService s) {
        this.service = s;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String s) {
        this.documentation = s;
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        WSDLParameter param;
        StringBuilder s = new StringBuilder();
        s.append(this.getName()).append("(");
        Iterator<WSDLParameter> i = this.inputs.iterator();
        while (i.hasNext()) {
            param = i.next();
            s.append(param.getName()).append(":").append(param.getType().getLocalPart());
            if (!i.hasNext()) continue;
            s.append(", ");
        }
        s.append(") -> (");
        i = this.outputs.iterator();
        while (i.hasNext()) {
            param = i.next();
            s.append(param.getName()).append(":").append(param.getType().getLocalPart());
            if (!i.hasNext()) continue;
            s.append(", ");
        }
        s.append(")");
        return s.toString();
    }

    public SOAPElement getResponse() {
        return this.response;
    }

    public void invoke() throws AxisFault, SOAPException {
        SOAPEnvelope request = this.createRequest();
        logger.debug("Invoke WSDL operation {}.", (Object)this.getDescription());
        SOAPEnvelope reply = this.call.invoke(request);
        this.processResult(reply);
    }

    private void processResult(SOAPEnvelope reply) throws SOAPException {
        SOAPBody soapBody = reply.getBody();
        this.response = (SOAPElement)soapBody.getChildElements().next();
        Iterator messageParts = this.response.getChildElements();
        for (WSDLParameter output : this.outputs) {
            Iterator children;
            SOAPElement e = (SOAPElement)messageParts.next();
            output.setTextValue(e.toString());
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("processResult ").append(e).append(Utils.LINE_SEPARATOR);
                sb.append("getValue ").append(e.getValue()).append(Utils.LINE_SEPARATOR);
                sb.append("getType ").append(e.getNodeType() == 1).append(Utils.LINE_SEPARATOR);
                sb.append("getValue is null? ").append(e.getValue() == null).append(Utils.LINE_SEPARATOR);
                sb.append("result has children? ").append(e.getChildElements().hasNext()).append(Utils.LINE_SEPARATOR);
                if (e.getChildElements().hasNext()) {
                    sb.append("result first child ").append(e.getChildElements().next());
                }
                logger.debug(sb.toString());
            }
            if ((children = e.getChildElements()).hasNext()) {
                Node child = (Node)children.next();
                if (child.getNodeType() == 3) {
                    output.setValue(child.toString());
                    continue;
                }
                output.setValue(e.toString());
                continue;
            }
            output.setValue(e.toString());
        }
    }

    private SOAPEnvelope createRequest() throws SOAPException {
        String targetNamespace = this.call.getOperationName().getNamespaceURI();
        String opName = this.call.getOperationName().getLocalPart();
        SOAPEnvelope envelope = new SOAPEnvelope();
        logger.debug("SOAP Action = {}, SOAP Action used = {}", (Object)this.call.getSOAPActionURI(), (Object)this.call.useSOAPAction());
        String inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        String nsOp = this.call.getOperationStyle().equals((Enum)Style.RPC) ? "u" : "";
        SOAPBodyElement soapBody = new SOAPBodyElement(envelope.createName(opName, nsOp, targetNamespace));
        envelope.addBodyElement(soapBody);
        for (WSDLParameter param : this.inputs) {
            Object paramValue = param.getValue();
            if (paramValue == null) continue;
            SOAPElement soapElement = soapBody.addChildElement(URIUtils.getLocalName(param.getName()), "");
            if (paramValue instanceof Node) {
                logger.debug("Case 1: DOM Node");
                this.createSOAPElement(soapElement, (Node)paramValue);
                if (soapElement.getAttributeValue((Name)WSDLConsts.xsiType) != null) continue;
                logger.debug("Case 1a");
                soapElement.addAttribute((Name)WSDLConsts.xsiType, "u:" + param.getType().getLocalPart());
                continue;
            }
            logger.debug("Case 2: {}", (Object)param.getType());
            soapElement.addAttribute((Name)WSDLConsts.xsiType, "xsd:" + param.getType().getLocalPart());
            soapElement.addTextNode(paramValue.toString());
        }
        return envelope;
    }

    private void createSOAPElement(SOAPElement parent, Node node) throws SOAPException {
        short type = node.getNodeType();
        switch (type) {
            case 3: {
                Node n;
                logger.debug("Case 3: DOM Text node.");
                String datatype = null;
                NamedNodeMap temp = node.getParentNode().getAttributes();
                if (temp != null && (n = temp.getNamedItemNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype")) != null && (datatype = n.getNodeValue()) != null) {
                    datatype = datatype.substring(datatype.indexOf("#") + 1);
                }
                if (datatype != null) {
                    parent.addAttribute((Name)WSDLConsts.xsiType, "xsd:" + datatype);
                }
                parent.addTextNode(node.getNodeValue());
                break;
            }
            case 1: {
                if (node.getParentNode() instanceof Document) {
                    logger.debug("Case 4: DOM Element node whose parent is DOM Document.");
                    this.processChildNodes(parent, node);
                    break;
                }
                logger.debug("Case 5: DOM Element node whose parent is not DOM Document.");
                this.processChildNodes(parent.addChildElement(node.getNodeName()), node);
                break;
            }
            case 9: {
                logger.debug("Case 3: DOM document node");
                this.processChildNodes(parent, node);
                break;
            }
        }
    }

    private void processChildNodes(SOAPElement target, Node source) throws SOAPException {
        NodeList children = source.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                this.createSOAPElement(target, children.item(i));
            }
        }
    }
}

