/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.mindswap.utils.Utils;
import org.mindswap.wsdl.WSDLOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLService {
    private static final Logger logger = LoggerFactory.getLogger(WSDLService.class);
    private Parser wsdlParser = null;
    private URI uri = null;
    private final Map<String, WSDLOperation> operations = new HashMap<String, WSDLOperation>();

    public WSDLService(URI wsdlURL) throws Exception {
        this.uri = wsdlURL;
        this.wsdlParser = new Parser();
        logger.debug("Reading WSDL document from {}", (Object)wsdlURL);
        this.wsdlParser.run(wsdlURL.toString());
        this.readOperations();
    }

    public static WSDLService createService(String wsdlLoc) throws Exception {
        return WSDLService.createService(URI.create(wsdlLoc));
    }

    public static WSDLService createService(URI wsdlLoc) throws Exception {
        WSDLService s = new WSDLService(wsdlLoc);
        return s;
    }

    private String createURI(QName qname) {
        return qname.getNamespaceURI() + "#" + qname.getLocalPart();
    }

    private String createURI(String localName) {
        return this.uri + "#" + localName;
    }

    private void readOperations() {
        try {
            String serviceNS = null;
            String serviceName = null;
            String operationName = null;
            String portName = null;
            Service service = this.selectService(serviceNS, serviceName);
            org.apache.axis.client.Service dpf = new org.apache.axis.client.Service(this.wsdlParser, service.getQName());
            Port port = this.selectPort(service.getPorts(), portName);
            if (portName == null) {
                portName = port.getName();
            }
            Binding binding = port.getBinding();
            SymbolTable symbolTable = this.wsdlParser.getSymbolTable();
            BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
            Parameters parameters = null;
            for (Operation o : bEntry.getParameters().keySet()) {
                Node doc;
                operationName = o.getName();
                Call call = (Call)dpf.createCall(QName.valueOf(portName), QName.valueOf(operationName));
                WSDLOperation op = new WSDLOperation(call);
                op.setService(this);
                this.operations.put(operationName, op);
                Message inputMessage = o.getInput().getMessage();
                Message outputMessage = o.getOutput().getMessage();
                op.setOperationName(this.createURI(operationName));
                op.setInputMessageName(this.createURI(inputMessage.getQName()));
                op.setOutputMessageName(this.createURI(outputMessage.getQName()));
                op.setPortName(this.createURI(port.getName()));
                if (logger.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Operation : ").append(operationName).append(Utils.LINE_SEPARATOR);
                    sb.append("Port      : ").append(portName).append(" -> ").append(op.getPortName()).append(Utils.LINE_SEPARATOR);
                    sb.append("Input Msg : ").append(inputMessage.getQName()).append(" -> ").append(op.getInputMessageName()).append(Utils.LINE_SEPARATOR);
                    sb.append("Output Msg: ").append(outputMessage.getQName()).append(" -> ").append(op.getOutputMessageName());
                    logger.debug(sb.toString());
                }
                if (o.getDocumentationElement() != null && (doc = o.getDocumentationElement().getFirstChild()) != null) {
                    op.setDocumentation(doc.getNodeValue());
                }
                parameters = (Parameters)bEntry.getParameters().get(o);
                for (int j = 0; j < parameters.list.size(); ++j) {
                    Parameter p = (Parameter)parameters.list.get(j);
                    String name = this.createURI(p.getName());
                    QName type = p.getType().getQName();
                    if (p.getMode() == 1) {
                        op.addInput(name, type);
                        logger.debug(" Input     : {} {}", (Object)name, (Object)type);
                        continue;
                    }
                    if (p.getMode() == 2) {
                        op.addOutput(name, type);
                        logger.debug(" Output    : {} {}", (Object)name, (Object)type);
                        continue;
                    }
                    if (p.getMode() != 3) continue;
                    op.addInput(name, type);
                    op.addOutput(name, type);
                    logger.warn("A WSDL parameter is defined as InOut is not tested yet.");
                    logger.debug(" InOut     : {} {}", (Object)name, (Object)type);
                }
                if (parameters.returnParam != null) {
                    Parameter p = parameters.returnParam;
                    String name = this.createURI(p.getName());
                    QName type = p.getType().getQName();
                    op.addOutput(name, type);
                    logger.debug(" Return    : {} {}", (Object)name, (Object)type);
                }
                if (!logger.isDebugEnabled()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("Inputs    : ").append(op.getInputs().size()).append(Utils.LINE_SEPARATOR);
                sb.append("Outputs   : ").append(op.getOutputs().size()).append(Utils.LINE_SEPARATOR);
                sb.append("Document  : ").append(op.getDocumentation());
                logger.debug(sb.toString());
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private Service selectService(String serviceNS, String serviceName) throws Exception {
        QName serviceQName = serviceNS != null && serviceName != null ? new QName(serviceNS, serviceName) : null;
        ServiceEntry serviceEntry = (ServiceEntry)this.getSymTabEntry(serviceQName, ServiceEntry.class);
        return serviceEntry.getService();
    }

    private SymTabEntry getSymTabEntry(QName qname, Class<ServiceEntry> cls) {
        HashMap map = this.wsdlParser.getSymbolTable().getHashMap();
        for (Map.Entry entry : map.entrySet()) {
            Vector v = (Vector)entry.getValue();
            if (qname != null && !qname.equals(entry.getKey())) continue;
            for (SymTabEntry symTabEntry : v) {
                if (!cls.isInstance(symTabEntry)) continue;
                return symTabEntry;
            }
        }
        return null;
    }

    private Port selectPort(Map<String, Port> ports, String portName) throws Exception {
        for (Map.Entry<String, Port> entry : ports.entrySet()) {
            String name = entry.getKey();
            if (portName == null || portName.length() == 0) {
                Port port = entry.getValue();
                List list = port.getExtensibilityElements();
                for (int i = 0; list != null && i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (!(obj instanceof SOAPAddress)) continue;
                    return port;
                }
                continue;
            }
            if (name == null || !name.equals(portName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public URI getFileURI() {
        return this.uri;
    }

    public List<WSDLOperation> getOperations() {
        return new ArrayList<WSDLOperation>(this.operations.values());
    }

    public WSDLOperation getOperation(String opName) {
        return this.operations.get(opName);
    }
}

