/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLType;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.utils.URIUtils;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;

public class WSDLTranslator {
    private final Service service;
    private final Profile profile;
    private final AtomicProcess process;
    private final WSDLAtomicGrounding wsdlAtomicGrounding;
    private final OWLOntology ont;
    private final URI baseURI;

    public WSDLTranslator(OWLOntology ont, WSDLOperation op, String prefix) {
        if (ont == null) {
            throw new IllegalArgumentException("Required ontology null");
        }
        if (op == null) {
            throw new IllegalArgumentException("Required WSDL operation null");
        }
        this.ont = ont;
        this.baseURI = ont.getURI();
        this.service = ont.createService(URIUtils.createURI(this.baseURI, prefix + "Service"));
        this.profile = ont.createProfile(URIUtils.createURI(this.baseURI, prefix + "Profile"));
        this.process = ont.createAtomicProcess(URIUtils.createURI(this.baseURI, prefix + "Process"));
        WSDLGrounding grounding = ont.createWSDLGrounding(URIUtils.createURI(this.baseURI, prefix + "Grounding"));
        this.wsdlAtomicGrounding = ont.createWSDLAtomicGrounding(URIUtils.createURI(this.baseURI, prefix + "AtomicProcessGrounding"));
        this.process.setLabel(this.process.getURI().getFragment(), null);
        this.service.addProfile(this.profile);
        this.service.setProcess(this.process);
        this.service.addGrounding(grounding);
        this.wsdlAtomicGrounding.setProcess(this.process);
        this.wsdlAtomicGrounding.setOperation(URI.create(op.getOperationName()));
        this.wsdlAtomicGrounding.setWSDL(op.getService().getFileURI());
        this.wsdlAtomicGrounding.setPortType(URI.create(op.getPortName()));
        this.wsdlAtomicGrounding.setInputMessage(URI.create(op.getInputMessageName()));
        this.wsdlAtomicGrounding.setOutputMessage(URI.create(op.getOutputMessageName()));
        grounding.addGrounding(this.wsdlAtomicGrounding);
    }

    public void setServiceName(String serviceName) {
        this.profile.setServiceName(serviceName);
    }

    public void setTextDescription(String textDescription) {
        this.profile.setTextDescription(textDescription);
        System.out.println(this.profile.getTextDescription());
    }

    public void addInput(WSDLParameter param, String paramName, URI paramType, String xsltTransformation) {
        Input input = this.ont.createInput(URIUtils.createURI(this.baseURI, paramName));
        input.setLabel(paramName, null);
        OWLType type = this.ont.getType(paramType);
        input.setParamType(type == null ? this.ont.createClass(paramType) : type);
        this.process.addInput(input);
        this.profile.addInput(input);
        this.wsdlAtomicGrounding.addMessageMap(input, param.getName(), xsltTransformation);
    }

    public void addOutput(WSDLParameter param, String paramName, URI paramType, String xsltTransformation) {
        Output output = this.ont.createOutput(URIUtils.createURI(this.baseURI, paramName));
        output.setLabel(paramName, null);
        OWLType type = this.ont.getType(paramType);
        output.setParamType(type == null ? this.ont.createClass(paramType) : type);
        this.process.addOutput(output);
        this.profile.addOutput(output);
        this.wsdlAtomicGrounding.addMessageMap(output, param.getName(), xsltTransformation);
    }

    public void writeOWLS(Writer out) {
        this.ont.write(out, this.baseURI);
    }

    public void writeOWLS(OutputStream out) {
        this.ont.write(out, this.baseURI);
    }

    public Service getService() {
        return this.service;
    }
}

