/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.avatar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.commons.codec.digest.DigestUtils;
import org.minijax.db.Avatar;
import org.minijax.db.NamedEntity;
import org.minijax.s3.UploadService;
import org.minijax.security.SecurityUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class AvatarService {
    private static final Logger LOG = LoggerFactory.getLogger(AvatarService.class);
    private static final String USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36";
    public static final double RESIZE_FACTOR = 0.5;
    @Context
    private Configuration config;
    @Inject
    private Client client;
    @Inject
    private UploadService uploadService;

    public boolean tryGravatar(SecurityUser user) throws IOException {
        String hash = DigestUtils.md5Hex((byte[])user.getEmail().getBytes("CP1252"));
        String url = "https://www.gravatar.com/avatar/" + hash + "?size=512&d=404";
        return this.tryRemotePicture((NamedEntity)user, url, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryRemotePicture(NamedEntity user, String url, int imageType) throws IOException {
        File tmpFile = File.createTempFile("temp-avatar", null);
        try {
            this.downloadFile(url, tmpFile);
            BufferedImage image = ImageIO.read(tmpFile);
            if (image == null) {
                boolean bl = false;
                return bl;
            }
            this.setAvatarImage(user, image);
            user.getAvatar().setImageType(imageType);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            LOG.warn("Error processing remote profile picture: {}", (Object)ex.getMessage(), (Object)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                AvatarService.forceDelete(tmpFile);
            }
            catch (IOException ex) {
                LOG.error("Error deleting temp file: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    public static BufferedImage createThumbnail(BufferedImage image, Color bg, int target) {
        int size;
        int y;
        int x;
        Objects.requireNonNull(image);
        Objects.requireNonNull(bg);
        int width = image.getWidth();
        int height = image.getHeight();
        if (width > height) {
            x = (width - height) / 2;
            y = 0;
            size = height;
        } else {
            x = 0;
            y = (height - width) / 2;
            size = width;
        }
        int nextStep = (int)Math.round((double)size * 0.5);
        if (nextStep < target) {
            nextStep = target;
        }
        BufferedImage dimg = new BufferedImage(nextStep, nextStep, 1);
        Graphics2D g = dimg.createGraphics();
        g.setColor(bg);
        g.fillRect(0, 0, nextStep, nextStep);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(image, 0, 0, nextStep, nextStep, x, y, x + size, y + size, bg, null);
        g.dispose();
        if (nextStep <= target) {
            return dimg;
        }
        return AvatarService.createThumbnail(dimg, bg, target);
    }

    public static BufferedImage generateAvatarImage() {
        float hue = (float)Math.random();
        Color background = Color.getHSBColor(hue, 0.66f, 0.67f);
        Color dark = Color.getHSBColor(hue, 0.84f, 0.5f);
        Color light = Color.getHSBColor(hue, 0.33f, 1.0f);
        BufferedImage image = new BufferedImage(256, 256, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(background);
        g.fillRect(0, 0, 256, 256);
        for (int y = 1; y < 7; ++y) {
            for (int x = 1; x < 4; ++x) {
                double p = Math.random();
                if (!(p > 0.5)) continue;
                g.setColor(p > 0.8 ? light : dark);
                g.fillRect(x * 32, y * 32, 32, 32);
                g.fillRect(224 - x * 32, y * 32, 32, 32);
            }
        }
        g.dispose();
        return image;
    }

    public void generateAvatarImage(NamedEntity owner) throws IOException {
        this.setAvatarImage(owner, AvatarService.generateAvatarImage());
    }

    public void handleFileUpload(NamedEntity entity, InputStream file) throws IOException {
        if (file == null) {
            return;
        }
        BufferedImage originalImage = ImageIO.read(file);
        if (originalImage == null) {
            return;
        }
        this.setAvatarImage(entity, originalImage);
        entity.getAvatar().setImageType(1);
    }

    private void setAvatarImage(NamedEntity owner, BufferedImage originalImage) throws IOException {
        Objects.requireNonNull(originalImage);
        Avatar avatar = owner.getAvatar();
        if (avatar == null) {
            avatar = new Avatar();
            owner.setAvatar(avatar);
        }
        BufferedImage image = AvatarService.createThumbnail(originalImage, Color.white, 256);
        avatar.setImageUrl(this.uploadImage(image));
        BufferedImage thumb = AvatarService.createThumbnail(image, Color.white, 64);
        avatar.setThumbUrl(this.uploadImage(thumb));
    }

    private String uploadImage(BufferedImage image) throws IOException {
        File imageFile = File.createTempFile("picture-", ".jpg");
        ImageIO.write((RenderedImage)image, "jpg", imageFile);
        String bucketName = (String)this.config.getProperty("org.minijax.avatar.bucketName");
        String keyName = String.format("avatars/%s.jpg", UUID.randomUUID());
        String resultUrl = this.uploadService.upload(bucketName, keyName, imageFile);
        AvatarService.forceDelete(imageFile);
        return resultUrl;
    }

    private void downloadFile(String url, File destFile) throws IOException {
        WebTarget target = this.client.target(url);
        if (target != null) {
            try (InputStream in = (InputStream)target.request().header("User-Agent", (Object)USER_AGENT).get(InputStream.class);){
                Files.copy(in, destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static void forceDelete(File file) throws IOException {
        Files.delete(file.toPath());
    }
}

