/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.cdi;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.InjectionException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.minijax.cdi.ConstructorProvider;
import org.minijax.cdi.Key;
import org.minijax.cdi.MinijaxInjectorState;
import org.minijax.cdi.MinijaxProvider;
import org.minijax.cdi.SingletonProvider;
import org.minijax.cdi.WrapperProvider;
import org.minijax.cdi.annotation.DefaultFieldAnnotationProcessor;
import org.minijax.cdi.annotation.FieldAnnotationProcessor;
import org.minijax.cdi.annotation.SingletonAnnotationProcessor;
import org.minijax.cdi.annotation.TypeAnnotationProcessor;
import org.minijax.commons.CloseUtils;
import org.minijax.commons.CopyOnWriteMap;

public class MinijaxInjector
implements Closeable {
    private final Map<Class<? extends Annotation>, TypeAnnotationProcessor<?>> typeAnnotationProcessors = new CopyOnWriteMap();
    private final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> fieldAnnotationProcessors = new CopyOnWriteMap();
    private final Map<Key<?>, MinijaxProvider<?>> providers = new CopyOnWriteMap();

    public MinijaxInjector() {
        this.typeAnnotationProcessors.put(Singleton.class, new SingletonAnnotationProcessor());
        this.fieldAnnotationProcessors.put(Inject.class, new DefaultFieldAnnotationProcessor());
    }

    public void addTypeAnnotationProcessor(Class<? extends Annotation> annotationType, TypeAnnotationProcessor<?> processor) {
        this.typeAnnotationProcessors.put(annotationType, processor);
    }

    public void addFieldAnnotationProcessor(Class<? extends Annotation> annotationType, FieldAnnotationProcessor<?> processor) {
        this.fieldAnnotationProcessors.put(annotationType, processor);
    }

    public boolean isInjectedField(Class<?> annotationType) {
        return this.fieldAnnotationProcessors.containsKey(annotationType);
    }

    <T> Key<T> buildKey(Class<T> type) {
        return new Key<T>(type);
    }

    <T> Key<T> buildKey(Class<T> type, Class<? extends Annotation> qualifier) {
        return new Key<T>(type, qualifier);
    }

    <T> Key<T> buildKey(Class<T> type, String name) {
        return new Key<T>(type, name);
    }

    <T> Key<T> buildKey(Class<T> type, Annotation[] annotations) {
        Annotation injectAnnotation = null;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == Inject.class || !this.fieldAnnotationProcessors.containsKey(annotationType)) continue;
            if (injectAnnotation != null) {
                throw new InjectionException("Multiple injection annotations");
            }
            injectAnnotation = annotation;
        }
        return new Key<T>(type, injectAnnotation, annotations);
    }

    public MinijaxInjector register(Object instance, Class<?> contract) {
        MinijaxProvider<Object> provider = instance instanceof MinijaxProvider ? (SingletonProvider<Object>)instance : (instance instanceof Provider ? new WrapperProvider((Provider)instance) : new SingletonProvider<Object>(instance));
        this.providers.put(this.buildKey(contract), provider);
        return this;
    }

    public MinijaxInjector register(Class<?> component, Class<?> contract) {
        this.providers.put(this.buildKey(contract), this.getProvider(component));
        return this;
    }

    public MinijaxInjector register(Class<?> component, Class<?> contract, Class<? extends Annotation> qualifier) {
        this.providers.put(this.buildKey(contract, qualifier), this.getProvider(component));
        return this;
    }

    public MinijaxInjector register(Class<?> component, Class<?> contract, String name) {
        this.providers.put(this.buildKey(contract, name), this.getProvider(component));
        return this;
    }

    public Set<Object> getSingletons() {
        HashSet<Object> result = new HashSet<Object>();
        for (MinijaxProvider<?> provider : this.providers.values()) {
            if (!(provider instanceof SingletonProvider)) continue;
            result.add(provider.get(null));
        }
        return result;
    }

    public <T> T getResource(Class<T> c) {
        return this.getProvider(c).get();
    }

    public <T> T getResource(Class<T> c, Object context) {
        return this.getProvider(c).get(context);
    }

    public <T> T initResource(T resource, Object context) {
        MinijaxProvider<?> provider = this.getProvider(resource.getClass());
        if (!(provider instanceof ConstructorProvider)) {
            throw new InjectionException("Cannot init resource class " + resource.getClass());
        }
        ConstructorProvider ctorProvider = (ConstructorProvider)provider;
        ctorProvider.initResource(resource, context);
        return resource;
    }

    public <T> MinijaxProvider<T> getProvider(Class<T> c) {
        return this.getProvider(this.buildKey(c), null, null);
    }

    public <T> MinijaxProvider<T> getProvider(Class<T> c, Annotation[] annotations) {
        return this.getProvider(this.buildKey(c, annotations), null, annotations);
    }

    <T> MinijaxProvider<T> getProvider(Key<T> key, Set<Key<?>> chain, Annotation[] annotations) {
        MinijaxProvider<Object> result = this.providers.get(key);
        if (result == null) {
            result = this.buildProvider(key, chain, annotations);
            this.providers.put(key, result);
        }
        return result;
    }

    private <T> MinijaxProvider<T> buildProvider(Key<T> key, Set<Key<?>> chain, Annotation[] fieldAnnotations) {
        Annotation[] typeAnnotations;
        FieldAnnotationProcessor<Object> processor = null;
        if (fieldAnnotations != null) {
            for (Annotation fieldAnnotation : fieldAnnotations) {
                FieldAnnotationProcessor<?> p = this.fieldAnnotationProcessors.get(fieldAnnotation.annotationType());
                if (p == null) continue;
                if (processor != null) {
                    throw new InjectionException("Conflicting field annotations");
                }
                processor = p;
            }
        }
        if (processor == null) {
            processor = new DefaultFieldAnnotationProcessor<T>();
        }
        MinijaxProvider<Object> provider = processor.buildProvider(new MinijaxInjectorState(this, key, chain), key.getType(), fieldAnnotations);
        for (Annotation typeAnnotation : typeAnnotations = key.getType().getAnnotations()) {
            TypeAnnotationProcessor<?> p = this.typeAnnotationProcessors.get(typeAnnotation.annotationType());
            if (p == null) continue;
            provider = p.buildProvider(provider, typeAnnotations);
        }
        return provider;
    }

    @Override
    public void close() {
        CloseUtils.closeQuietly(this.providers.values());
    }
}

