/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.cdi;

import jakarta.enterprise.inject.InjectionException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.minijax.cdi.ConstructorProvider;
import org.minijax.cdi.FieldProvider;
import org.minijax.cdi.InjectionSet;
import org.minijax.cdi.Key;
import org.minijax.cdi.MethodProvider;
import org.minijax.cdi.MinijaxInjector;
import org.minijax.cdi.MinijaxInjectorState;
import org.minijax.cdi.MinijaxProvider;

public class ConstructorProviderBuilder<T> {
    private final MinijaxInjector injector;
    private final Key<T> key;
    private final Set<Key<?>> chain;
    private final List<Class<?>> types;
    private final Map<String, Method> map;
    private final Map<Class<?>, List<Method>> typeMethods;
    private final List<Method> toRemove;

    public ConstructorProviderBuilder(MinijaxInjectorState state) {
        if (state.getKey().getType().isInterface()) {
            throw new IllegalStateException("Cannot create interface " + state.getKey().getType());
        }
        this.injector = state.getInjector();
        this.key = state.getKey();
        this.chain = state.getChain();
        this.types = ConstructorProviderBuilder.getTypeList(this.key.getType());
        this.map = new HashMap<String, Method>();
        this.typeMethods = new HashMap();
        this.toRemove = new ArrayList<Method>();
    }

    public ConstructorProvider<T> build() {
        Constructor<T> constructor = ConstructorProviderBuilder.getConstructor(this.key.getType());
        MinijaxProvider<T>[] paramProviders = this.getParamProviders(this.key, constructor, this.chain);
        List<InjectionSet> injectionSets = this.buildInjectionSets();
        return new ConstructorProvider<T>(constructor, paramProviders, injectionSets);
    }

    private static <T> Constructor<T> getConstructor(Class<T> type) {
        Constructor<?> constructor;
        boolean staticClass = Modifier.isStatic(type.getModifiers());
        Class<?> parentClass = type.getDeclaringClass();
        boolean innerClass = !staticClass && parentClass != null;
        Constructor<?> inject = null;
        Constructor<?> noarg = null;
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            if (c.isAnnotationPresent(Inject.class)) {
                if (inject == null) {
                    inject = c;
                    continue;
                }
                throw new InjectionException(String.format("%s has multiple @Inject constructors", type));
            }
            if (c.getParameterTypes().length == 0) {
                noarg = c;
                continue;
            }
            if (!innerClass || c.getParameterTypes().length != 1) continue;
            noarg = c;
        }
        Constructor<?> constructor2 = constructor = inject != null ? inject : noarg;
        if (constructor == null) {
            throw new InjectionException(String.format("%s doesn't have an @Inject or no-arg constructor, or a module provider", type.getName()));
        }
        constructor.setAccessible(true);
        return constructor;
    }

    private List<InjectionSet> buildInjectionSets() {
        for (Class<?> type : this.types) {
            this.processType(type);
        }
        ArrayList<InjectionSet> result = new ArrayList<InjectionSet>(this.types.size());
        for (Class<?> type : this.types) {
            result.add(this.buildInjectionSet(this.key, this.chain, type, this.typeMethods, this.toRemove));
        }
        return result;
    }

    private void processType(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : type.getDeclaredMethods()) {
            if (!this.processMethod(method)) continue;
            methods.add(method);
        }
        this.typeMethods.put(type, methods);
    }

    private boolean processMethod(Method method) {
        int mod;
        Method oldMethod;
        boolean candidate = ConstructorProviderBuilder.isCandidate(method);
        String shortKey = ConstructorProviderBuilder.buildShortKey(method);
        String packageKey = ConstructorProviderBuilder.getPackageName(method) + " " + shortKey;
        if (this.map.containsKey(packageKey) && (oldMethod = this.map.get(packageKey)) != null) {
            int mod2 = oldMethod.getModifiers();
            if (!Modifier.isPrivate(mod2) && !Modifier.isStatic(mod2) && mod2 != 0 || ConstructorProviderBuilder.isSamePackage(oldMethod, method)) {
                this.toRemove.add(this.map.get(packageKey));
            }
        } else if (this.map.containsKey(shortKey) && (oldMethod = this.map.get(shortKey)) != null && (Modifier.isPublic(mod = oldMethod.getModifiers()) || Modifier.isProtected(mod))) {
            this.toRemove.add(this.map.get(shortKey));
        }
        if (candidate) {
            method.setAccessible(true);
            this.map.put(packageKey, method);
            this.map.put(shortKey, method);
        }
        return candidate;
    }

    private static boolean isCandidate(Method method) {
        return method.isAnnotationPresent(Inject.class) && !Modifier.isAbstract(method.getModifiers());
    }

    private <T1, T2> InjectionSet buildInjectionSet(Key<T1> key, Set<Key<?>> chain, Class<T2> type, Map<Class<?>, List<Method>> typeMethods, List<Method> toRemove) {
        ArrayList<Method> staticMethods = new ArrayList<Method>();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : typeMethods.get(type)) {
            if (toRemove.contains(method)) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                staticMethods.add(method);
                continue;
            }
            methods.add(method);
        }
        List<FieldProvider<?>> fieldProviders = this.getFieldProviders(key, type, chain);
        ArrayList<MethodProvider> staticMethodProviders = new ArrayList<MethodProvider>();
        for (Method method : staticMethods) {
            staticMethodProviders.add(new MethodProvider(method, this.getParamProviders(key, method, chain)));
        }
        ArrayList<MethodProvider> methodProviders = new ArrayList<MethodProvider>();
        for (Method method : methods) {
            methodProviders.add(new MethodProvider(method, this.getParamProviders(key, method, chain)));
        }
        return new InjectionSet(fieldProviders, methodProviders);
    }

    private static List<Class<?>> getTypeList(Class<?> type) {
        ArrayList types = new ArrayList();
        for (Class<?> current = type; current != Object.class; current = current.getSuperclass()) {
            types.add(current);
        }
        Collections.reverse(types);
        return types;
    }

    private <T1, T2> List<FieldProvider<?>> getFieldProviders(Key<T1> key, Class<T2> target, Set<Key<?>> chain) {
        Set<Field> fields = this.getFields(target);
        ArrayList result = new ArrayList(fields.size());
        for (Field field : fields) {
            result.add(new FieldProvider<T1>(field, this.getParamProvider(key, field.getType(), field.getGenericType(), field.getAnnotations(), chain)));
        }
        return result;
    }

    private Set<Field> getFields(Class<?> type) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Field field : type.getDeclaredFields()) {
            if (!this.isInjectedField(field)) continue;
            field.setAccessible(true);
            fields.add(field);
        }
        return fields;
    }

    private boolean isInjectedField(Field field) {
        for (Annotation a : field.getDeclaredAnnotations()) {
            Class<? extends Annotation> t = a.annotationType();
            if (!this.injector.isInjectedField(t)) continue;
            return true;
        }
        return false;
    }

    private MinijaxProvider<?>[] getParamProviders(Key<?> key, Executable executable, Set<Key<?>> chain) {
        Class<?>[] paramClasses = executable.getParameterTypes();
        Type[] paramTypes = executable.getGenericParameterTypes();
        Annotation[][] annotations = executable.getParameterAnnotations();
        MinijaxProvider[] result = new MinijaxProvider[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            result[i] = this.getParamProvider(key, paramClasses[i], paramTypes[i], annotations[i], chain);
        }
        return result;
    }

    private MinijaxProvider<?> getParamProvider(Key<?> key, Class<?> parameterClass, Type paramType, Annotation[] paramAnnotations, Set<Key<?>> chain) {
        Class providerType;
        Class clazz = providerType = Provider.class.equals(parameterClass) ? (Class)((ParameterizedType)paramType).getActualTypeArguments()[0] : null;
        if (providerType == null) {
            Key<?> newKey = this.injector.buildKey(parameterClass, paramAnnotations);
            Set<Key<?>> newChain = ConstructorProviderBuilder.append(chain, key);
            if (newChain.contains(newKey)) {
                throw new InjectionException(String.format("Circular dependency: %s", ConstructorProviderBuilder.chain(newChain, newKey)));
            }
            return this.injector.getProvider(newKey, newChain, paramAnnotations);
        }
        Key newKey = this.injector.buildKey(providerType, paramAnnotations);
        return context -> this.injector.getProvider(newKey, null, paramAnnotations);
    }

    private static Set<Key<?>> append(Set<Key<?>> set, Key<?> newKey) {
        if (set != null) {
            LinkedHashSet appended = new LinkedHashSet(set);
            appended.add(newKey);
            return appended;
        }
        return Collections.singleton(newKey);
    }

    private static String chain(Set<Key<?>> chain, Key<?> lastKey) {
        StringBuilder chainString = new StringBuilder();
        for (Key<?> key : chain) {
            chainString.append(key.toString()).append(" -> \n");
        }
        return chainString.append(lastKey.toString()).toString();
    }

    private static String buildShortKey(Method method) {
        return method.getReturnType().toString() + " " + method.getName() + " " + Arrays.toString(method.getParameterTypes());
    }

    private static String getPackageName(Method method) {
        String name = method.getDeclaringClass().getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(0, index);
    }

    private static boolean isSamePackage(Method oldMethod, Method method) {
        return oldMethod.getDeclaringClass().getPackage().equals(method.getDeclaringClass().getPackage());
    }
}

