/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.cdi;

import jakarta.enterprise.inject.InjectionException;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.util.Objects;

class Key<T> {
    protected final Class<T> type;
    private final Annotation injectAnnotation;
    private final Class<? extends Annotation> qualifier;
    private final String name;

    public Key(Class<T> type) {
        this.type = type;
        this.injectAnnotation = null;
        this.qualifier = null;
        this.name = null;
    }

    public Key(Class<T> type, Class<? extends Annotation> qualifier) {
        this.type = type;
        this.injectAnnotation = null;
        this.qualifier = qualifier;
        this.name = null;
    }

    public Key(Class<T> type, String name) {
        this.type = type;
        this.injectAnnotation = null;
        this.qualifier = Named.class;
        this.name = name;
    }

    public Key(Class<T> type, Annotation injectAnnotation, Annotation[] annotations) {
        Class<? extends Annotation> qualifier = null;
        String name = null;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                if (qualifier != null) {
                    throw new InjectionException("Multiple qualifiers");
                }
                qualifier = annotation.annotationType();
                if (annotation.annotationType() != Named.class) continue;
                name = ((Named)annotation).value();
            }
        }
        this.type = type;
        this.injectAnnotation = injectAnnotation;
        this.qualifier = qualifier;
        this.name = name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.type.hashCode();
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        if (this.injectAnnotation != null) {
            result = 31 * result + this.injectAnnotation.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Key other = (Key)obj;
        return this.type == other.type && this.injectAnnotation == other.injectAnnotation && Objects.equals(this.qualifier, other.qualifier) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "Key [type=" + this.type + ", qualifier=" + this.qualifier + ", name=" + this.name + "]";
    }
}

