/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.cdi;

import jakarta.enterprise.inject.InjectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.minijax.cdi.FieldProvider;
import org.minijax.cdi.InjectionSet;
import org.minijax.cdi.MethodProvider;
import org.minijax.cdi.MinijaxProvider;

public class ConstructorProvider<T>
implements MinijaxProvider<T> {
    private final Constructor<T> ctor;
    private final MinijaxProvider<?>[] paramProviders;
    private final List<InjectionSet> injectionSets;

    public ConstructorProvider(Constructor<T> ctor, MinijaxProvider<?>[] paramProviders, List<InjectionSet> injectionSets) {
        this.ctor = ctor;
        this.paramProviders = paramProviders;
        this.injectionSets = injectionSets;
    }

    @Override
    public T get(Object context) {
        try {
            T result = this.ctor.newInstance(this.getParams(this.paramProviders, context));
            this.initImpl(result, context);
            return result;
        }
        catch (InvocationTargetException ex) {
            Throwable inner = ex.getCause();
            throw new InjectionException(inner.getMessage(), inner);
        }
        catch (Exception e) {
            throw new InjectionException(String.format("Can't instantiate %s", this.ctor), (Throwable)e);
        }
    }

    public T initResource(T instance, Object context) {
        try {
            this.initImpl(instance, context);
            return instance;
        }
        catch (InvocationTargetException ex) {
            Throwable inner = ex.getCause();
            throw new InjectionException(inner.getMessage(), inner);
        }
        catch (Exception e) {
            throw new InjectionException(String.format("Can't initialize %s", instance), (Throwable)e);
        }
    }

    public void initImpl(T result, Object context) throws IllegalAccessException, InvocationTargetException {
        for (InjectionSet injectionSet : this.injectionSets) {
            for (FieldProvider<?> fieldProvider : injectionSet.getFieldProviders()) {
                fieldProvider.getField().set(result, fieldProvider.getProvider().get(context));
            }
            for (MethodProvider methodProvider : injectionSet.getMethodProviders()) {
                methodProvider.getMethod().invoke(result, this.getParams(methodProvider.getParamProviders(), context));
            }
        }
    }

    private Object[] getParams(MinijaxProvider<?>[] providers, Object context) {
        Object[] params = new Object[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            params[i] = providers[i].get(context);
        }
        return params;
    }
}

