/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.cloudwatch;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CloudWatchAppender
extends AppenderBase<ILoggingEvent> {
    private static final long PERIOD = 5000L;
    private final Object lockObject = new Object();
    private final List<InputLogEvent> eventQueue = Collections.synchronizedList(new ArrayList());
    private Layout<ILoggingEvent> layout;
    private String logGroupName;
    private String logStreamName;
    private AWSLogs awsLogs;
    private String sequenceToken;

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogStreamName() {
        return this.logStreamName;
    }

    public void setLogStreamName(String logStreamName) {
        this.logStreamName = logStreamName;
    }

    public AWSLogs getAwsLogs() {
        return this.awsLogs;
    }

    public void setAwsLogs(AWSLogs awsLogs) {
        this.awsLogs = awsLogs;
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.layout == null) {
            this.layout = new EchoLayout();
            this.addStatus((Status)new WarnStatus("No layout, default to " + this.layout, (Object)this));
        }
        if (this.logGroupName == null) {
            this.logGroupName = ((Object)((Object)this)).getClass().getSimpleName();
            this.addStatus((Status)new WarnStatus("No logGroupName, default to " + this.logGroupName, (Object)this));
        }
        if (this.logStreamName == null) {
            this.logStreamName = new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(new Date());
            this.addStatus((Status)new WarnStatus("No logGroupName, default to " + this.logStreamName, (Object)this));
        }
        try {
            if (this.awsLogs == null) {
                this.awsLogs = AWSLogsClientBuilder.defaultClient();
            }
            this.createLogGroup();
            this.createLogStream();
        }
        catch (AmazonClientException e) {
            this.awsLogs = null;
            this.addStatus((Status)new ErrorStatus(e.getMessage(), (Object)this, (Throwable)e));
        }
        new DaemonTimerThread().start();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.layout.start();
        super.start();
    }

    public synchronized void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.uploadEvents(this.getBatch());
        if (this.awsLogs != null) {
            this.awsLogs.shutdown();
            this.awsLogs = null;
        }
        super.stop();
        this.layout.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent event) {
        Object object = this.lockObject;
        synchronized (object) {
            this.eventQueue.add(new InputLogEvent().withTimestamp(Long.valueOf(event.getTimeStamp())).withMessage(this.layout.doLayout((Object)event)));
        }
    }

    private void createLogGroup() {
        try {
            this.awsLogs.createLogGroup(new CreateLogGroupRequest().withLogGroupName(this.logGroupName));
        }
        catch (ResourceAlreadyExistsException e) {
            this.addStatus((Status)new InfoStatus(e.getMessage(), (Object)this));
        }
    }

    private void createLogStream() {
        try {
            this.awsLogs.createLogStream(new CreateLogStreamRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName));
        }
        catch (ResourceAlreadyExistsException e) {
            this.addStatus((Status)new InfoStatus(e.getMessage(), (Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<InputLogEvent> getBatch() {
        Object object = this.lockObject;
        synchronized (object) {
            ArrayList<InputLogEvent> result = new ArrayList<InputLogEvent>(this.eventQueue);
            this.eventQueue.clear();
            return result;
        }
    }

    private void uploadEvents(Collection<InputLogEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        try {
            PutLogEventsRequest request = new PutLogEventsRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName).withSequenceToken(this.sequenceToken).withLogEvents(events);
            PutLogEventsResult result = this.awsLogs.putLogEvents(request);
            this.sequenceToken = result.getNextSequenceToken();
        }
        catch (DataAlreadyAcceptedException e) {
            this.sequenceToken = e.getExpectedSequenceToken();
        }
        catch (InvalidSequenceTokenException e) {
            this.sequenceToken = e.getExpectedSequenceToken();
            this.uploadEvents(events);
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            CloudWatchAppender.this.uploadEvents(CloudWatchAppender.this.getBatch());
        }
    }

    private class DaemonTimerThread
    extends Thread {
        public DaemonTimerThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                CloudWatchAppender.this.uploadEvents(CloudWatchAppender.this.getBatch());
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }
}

