/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.dao;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.minijax.dao.BaseDao;
import org.minijax.dao.BaseEntity;
import org.minijax.dao.ConflictException;
import org.minijax.dao.NamedEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBaseDao
implements BaseDao {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBaseDao.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public <T extends BaseEntity> T create(T obj) {
        try {
            this.em.getTransaction().begin();
            this.em.persist(obj);
            this.em.getTransaction().commit();
            return obj;
        }
        catch (PersistenceException ex) {
            throw DefaultBaseDao.convertRollbackToConflict(ex);
        }
    }

    @Override
    public <T extends BaseEntity> T read(Class<T> entityClass, UUID id) {
        return (T)((BaseEntity)this.em.find(entityClass, (Object)id));
    }

    @Override
    public <T extends NamedEntity> T readByHandle(Class<T> entityClass, String handle) {
        return (T)((NamedEntity)BaseDao.firstOrNull(this.em.createQuery("SELECT e FROM " + entityClass.getSimpleName() + " e WHERE e.handle = :handle", entityClass).setParameter("handle", (Object)handle).getResultList()));
    }

    @Override
    public <T extends BaseEntity> List<T> readPage(Class<T> entityClass, int page, int pageSize) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityClass);
        Root root = cq.from(entityClass);
        cq.select((Selection)root);
        cq.orderBy(new Order[]{cb.desc((Expression)root.get("id"))});
        return this.em.createQuery(cq).setFirstResult(page * pageSize).setMaxResults(pageSize).getResultList();
    }

    @Override
    public <T extends BaseEntity> T update(T obj) {
        try {
            this.em.getTransaction().begin();
            this.em.merge(obj);
            this.em.getTransaction().commit();
            return obj;
        }
        catch (PersistenceException ex) {
            throw DefaultBaseDao.convertRollbackToConflict(ex);
        }
    }

    @Override
    public <T extends BaseEntity> void delete(T obj) {
        obj.setDeleted(true);
        this.update(obj);
    }

    @Override
    public <T extends BaseEntity> void purge(T obj) {
        BaseEntity actual = (BaseEntity)this.em.find(obj.getClass(), (Object)obj.getId());
        if (actual != null) {
            this.em.getTransaction().begin();
            this.em.remove((Object)actual);
            this.em.getTransaction().commit();
        }
    }

    @Override
    public <T extends BaseEntity> long countAll(Class<T> entityClass) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        return (Long)this.em.createQuery(cq.select((Selection)cb.count((Expression)cq.from(entityClass)))).getSingleResult();
    }

    private static ConflictException convertRollbackToConflict(PersistenceException ex) {
        List<Pattern> patterns = Arrays.asList(Pattern.compile("Duplicate entry '(?<value>[^']+)' for key '(?<key>[^']+)'"), Pattern.compile("CONSTRAINT_INDEX_[a-zA-Z0-9_]+ ON PUBLIC\\.[a-zA-Z]+\\((?<key>[a-zA-Z]+)\\) VALUES \\('(?<value>[^']+)'"), Pattern.compile("CONSTRAINT_INDEX_[a-zA-Z0-9_]+ ON PUBLIC\\.[a-zA-Z]+\\((?<key>[a-zA-Z]+)\\) VALUES (?<value>\\d+)"));
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(ex.getMessage());
            if (!matcher.find()) continue;
            String key = matcher.group("key").toLowerCase();
            return new ConflictException(key);
        }
        LOG.warn("Unrecognized RollbackException: {}", (Object)ex.getMessage(), (Object)ex);
        throw ex;
    }
}

