/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.dao;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.eclipse.persistence.annotations.CacheIndex;
import org.minijax.dao.Avatar;
import org.minijax.dao.DefaultBaseEntity;
import org.minijax.dao.NamedEntity;

@MappedSuperclass
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class DefaultNamedEntity
extends DefaultBaseEntity
implements NamedEntity {
    private static final long serialVersionUID = 1L;
    public static final String HANDLE_SPECIAL_CHARS = "!#$%&'()*+,/:;=?@[\\]^`{|}~";
    public static final String HANDLE_SPECIAL_CHARS_REGEX = java.util.regex.Pattern.quote("!#$%&'()*+,/:;=?@[\\]^`{|}~");
    public static final String HANDLE_REGEX = "[^\\." + HANDLE_SPECIAL_CHARS_REGEX + "][^" + HANDLE_SPECIAL_CHARS_REGEX + "]*";
    @Column(length=32, unique=true)
    @CacheIndex
    @Size(min=1, max=32)
    @Pattern(regexp="[^\\.\\Q!#$%&'()*+,/:;=?@[\\]^`{|}~\\E][^\\Q!#$%&'()*+,/:;=?@[\\]^`{|}~\\E]*")
    private @Size(min=1, max=32) @Pattern(regexp="[^\\.\\Q!#$%&'()*+,/:;=?@[\\]^`{|}~\\E][^\\Q!#$%&'()*+,/:;=?@[\\]^`{|}~\\E]*") String handle;
    @NotNull
    @Size(min=1, max=128)
    private @NotNull @Size(min=1, max=128) String name = "";
    @Embedded
    private Avatar avatar;

    protected DefaultNamedEntity() {
    }

    protected DefaultNamedEntity(String name) {
        this.setName(name);
    }

    @Override
    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle != null ? handle.trim() : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name != null ? name.trim() : "";
    }

    @Override
    public Avatar getAvatar() {
        return this.avatar;
    }

    @Override
    public void setAvatar(Avatar avatar) {
        this.avatar = avatar;
    }

    public void generateHandle() {
        String uuid = UUID.randomUUID().toString();
        this.handle = this.name == null ? uuid.substring(0, 16) : (this.name.replaceAll("[^A-Za-z0-9]", "") + "-" + uuid.substring(0, 6)).toLowerCase();
    }
}

