/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.dao;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.inject.InjectionException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import org.minijax.cdi.MinijaxInjectorState;
import org.minijax.cdi.MinijaxProvider;
import org.minijax.cdi.annotation.FieldAnnotationProcessor;
import org.minijax.dao.EntityManagerProvider;

public class PersistenceContextAnnotationProcessor
implements FieldAnnotationProcessor<EntityManager> {
    private final Map<String, EntityManagerFactory> factories;

    public PersistenceContextAnnotationProcessor(Map<String, EntityManagerFactory> factories) {
        this.factories = factories;
    }

    public MinijaxProvider<EntityManager> buildProvider(MinijaxInjectorState state, Class<EntityManager> type, Annotation[] annotations) {
        PersistenceContext persistenceContext = this.getPersistenceContextAnnotation(annotations);
        EntityManagerFactory emf = this.factories.get(persistenceContext.name());
        if (emf == null) {
            throw new InjectionException("Persistence context \"" + persistenceContext.name() + "\" not found");
        }
        return new EntityManagerProvider(emf);
    }

    PersistenceContext getPersistenceContextAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != PersistenceContext.class) continue;
            return (PersistenceContext)annotation;
        }
        throw new InjectionException("Missing @PersistenceContext annotation");
    }
}

